/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.basic;

import cn.com.infosec.jce.PKCS7SignedDataFX;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.agent.ExtendInfoUtil;
import cn.com.infosec.netsign.agent.NetSignAgent;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.basic.SocketHandler;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.BarCodeParameters;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.PDFParameters;
import cn.com.infosec.netsign.base.util.TimeStampToken;
import cn.com.infosec.netsign.communication.multiple.MultiCommunicator;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataParser;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.OSCCAMessageDigest;
import cn.com.infosec.oscca.encryption.SM3Digest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class BasicNetSignAgent {
    public static final String version = "NetSignServer V5.5.40.12 Build201807261800";
    private SocketHandler sh;

    static {
        Security.insertProviderAt((Provider)new InfosecProvider(), 100);
    }

    public BasicNetSignAgent(SocketHandler sh) {
        if (sh == null) {
            throw new NullPointerException("SocketHandler is null");
        }
        this.sh = sh;
    }

    public NetSignResult addImage2PDF(PDFParameters para) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AddImage2PDFProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setPdfpasswd(para.getOwnerPassword());
        req.setPdfImages(para.getImages());
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.pdfSignatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedAfterwardsVerify(String signedText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedVerify(byte[] signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = signedText;
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedVerify(byte[] signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = signedText;
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        req.setDigestAlg(digestAlg);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedVerify(String signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedVerify(String signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        req.setDigestAlg(digestAlg);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult attachedVerify4UKey2G(byte[] signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        PKCS7SignedDataFX p7 = null;
        try {
            p7 = new PKCS7SignedDataFX(signedText, "INFOSEC");
        }
        catch (Exception e) {
            throw new ServerProcessException(-100004, "Unpackage PKCS7SignedData failed");
        }
        byte[] plainText = p7.getContentData();
        X509Certificate cert = p7.getSigningCertificate();
        byte[] signed = NetSignAgentUtil.getSignatureInPKCS7(signedText, cert);
        String digestAlg = p7.getDigestAlgorithm();
        int i = digestAlg.indexOf("with");
        if (i > 0) {
            digestAlg = digestAlg.substring(0, i);
        }
        NetSignResult result = this.RAWVerify4UKey2G(plainText, signed, cert, digestAlg, standard);
        NetSignAgentUtil.setVerifyResult(plainText, cert, needCert, result);
        return result;
    }

    public NetSignResult attachedVerify4UKey2G(String signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        return this.attachedVerify4UKey2G(NetSignAgentUtil.decode(signedText), tsaText, needCert, standard);
    }

    public static byte[] base64Decode(String b64) {
        if (b64 == null || b64.equals("")) {
            return null;
        }
        try {
            return NetSignAgentUtil.decode(b64);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base64Encode(byte[] bs) {
        if (bs == null || bs.length == 0) {
            return null;
        }
        return NetSignAgentUtil.encode(bs);
    }

    static void checkResult(AbstractMessage res) throws ServerProcessException {
        if (res.getResult() < 0) {
            if (NetSignAgent.getDebugWriter() != null) {
                NetSignAgent.getDebugWriter().println(new Date() + " Server process failed, " + "the error code is " + res.getResult() + ", the error is " + res.getErrMsg());
            }
            throw new ServerProcessException(res.getResult(), res.getErrMsg());
        }
    }

    public NetSignResult CMSAttachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("CMSAttachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult CMSDetachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("CMSDetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult decryptEnvelope(String encText, String subject) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoEnvelopedMSGProcessor");
        byte[] encBytes = NetSignAgentUtil.decode(encText);
        encBytes = NetSignAgentUtil.checkAndZip(encBytes, req);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.decryptEnvelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult decryptMSEnvelope(String encText, String subject) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoMSEnvelopedMSGProcessor");
        byte[] encBytes = NetSignAgentUtil.decode(encText);
        encBytes = NetSignAgentUtil.checkAndZip(encBytes, req);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.decryptEnvelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult decryptMSEnvelope(String encText, String subject, String digestAlg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoMSEnvelopedMSGProcessor");
        byte[] encBytes = NetSignAgentUtil.decode(encText);
        encBytes = NetSignAgentUtil.checkAndZip(encBytes, req);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.decryptEnvelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult detachedAfterwardsVerify(byte[] plainText, String signedText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult detachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult detachedVerify(byte[] plainText, byte[] signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = signedText;
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult detachedVerify(byte[] plainText, byte[] signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = signedText;
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult detachedVerify(byte[] plainText, String signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult detachedVerify(byte[] plainText, String signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult verifyTSASignature(byte[] plaintext, byte[] token) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyTSASignatureProcessor");
        TimeStampToken stampToken = null;
        try {
            stampToken = new TimeStampToken(token);
        }
        catch (Exception e) {
            throw new NetSignAgentException("Parse stamptoken error.");
        }
        String alg = stampToken.getMessageHashAlg();
        byte[] digestText = null;
        if (alg.equals("SM3")) {
            digestText = new byte[32];
            SM3Digest sm3 = new SM3Digest();
            sm3.update(plaintext);
            sm3.digest(digestText);
        } else {
            digestText = NetSignAgentUtil.digest(plaintext, alg);
        }
        digestText = NetSignAgentUtil.checkAndZip(digestText, req);
        digestText = NetSignAgentUtil.checkAndEncrypt(digestText, req);
        req.setCryptoText(token);
        req.setTSAText(digestText);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.TSASigVerifyResult(res);
        return result;
    }

    public NetSignResult detachedVerify4UKey2G(byte[] plainText, byte[] signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        PKCS7SignedDataFX p7 = null;
        try {
            p7 = new PKCS7SignedDataFX(signedText, "INFOSEC");
        }
        catch (Exception e) {
            throw new ServerProcessException(-100004, "Unpackage PKCS7SignedData failed");
        }
        X509Certificate cert = p7.getSigningCertificate();
        byte[] signed = NetSignAgentUtil.getSignatureInPKCS7(signedText, cert);
        String digestAlg = p7.getDigestAlgorithm();
        int i = digestAlg.indexOf("with");
        if (i > 0) {
            digestAlg = digestAlg.substring(0, i);
        }
        NetSignResult result = this.RAWVerify4UKey2G(plainText, signed, cert, digestAlg, standard);
        NetSignAgentUtil.setVerifyResult(null, cert, needCert, result);
        return result;
    }

    public NetSignResult detachedVerify4UKey2G(byte[] plainText, String signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        return this.detachedVerify4UKey2G(plainText, BasicNetSignAgent.base64Decode(signedText), tsaText, needCert, standard);
    }

    public void digestVerify(byte[] digest, byte[] signedText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DigestSignVerifyProcessor");
        req.setHashValue(digest);
        req.setCert(cert);
        req.setCryptoText(signedText);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        BasicNetSignAgent.freeObjects(req, res);
    }

    private static void freeObjects(AbstractMessage req, AbstractMessage resp) {
        req = null;
        resp = null;
    }

    public NetSignResult generateBarCode128(BarCodeParameters para, String msg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCode128Processor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult generateBarCode39(BarCodeParameters para, String msg, boolean addCheckSUM, float wideFactor, boolean displayStartStop) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCode39Processor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        req.setBcAddCheckSUM(addCheckSUM);
        req.setBcWideFactor(wideFactor);
        req.setBcDisplayHumanReadableStartStop(displayStartStop);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult generateBarCode417(byte[] msg, boolean isBinary, int errorCorrectLevel, float aspectRatio, float yheight, int returnFormat) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodePDF417Processor");
        req.setPlainText(msg);
        req.setBcEncodingMode(isBinary ? 0 : 1);
        req.setBcErrorCorrectingLevel(errorCorrectLevel);
        req.setBcAspectRatio(aspectRatio);
        req.setBcYHeight(yheight);
        req.setBcReturnFormat(returnFormat);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult generateBarCodeCodabar(BarCodeParameters para, String msg, float wideFactor, boolean displayStartStop) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodeCodabarProcessor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        req.setBcWideFactor(wideFactor);
        req.setBcDisplayHumanReadableStartStop(displayStartStop);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult generateBarCodeInter25(BarCodeParameters para, String msg, boolean addCheckSUM, float wideFactor) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodeInter25Processor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        req.setBcAddCheckSUM(addCheckSUM);
        req.setBcWideFactor(wideFactor);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult generateBarCodeQRCode(byte[] msg, int encodeMode, int errorCorrecting, int barSize, int returnFormat) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodeQRCodeProcessor");
        req.setPlainText(msg);
        req.setBcEncodingMode(encodeMode);
        req.setBcErrorCorrectingLevel(errorCorrecting);
        req.setBcBarSize(barSize);
        req.setBcReturnFormat(returnFormat);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509Certificate generateCertificate(byte[] cert) throws Exception {
        ByteArrayInputStream in = null;
        if (cert[0] == 48) {
            int tl = (cert[1] & 0xFF) - 128;
            if (tl <= 0) throw new CertificateException("Illegal code: 30 " + (cert[1] & 0xFF));
            byte[] ltmp = new byte[tl];
            System.arraycopy(cert, 2, ltmp, 0, tl);
            int length = new BigInteger(ltmp).intValue();
            if (length <= 0 || length != cert.length - 2 - tl) throw new CertificateException("Illegal length: " + length);
            in = new ByteArrayInputStream(cert);
        } else {
            String head = "-----BEGIN CERTIFICATE-----";
            String tail = "-----END CERTIFICATE-----";
            String b64Cert = new String(cert);
            if (b64Cert.indexOf(head) > -1) {
                b64Cert = b64Cert.replaceFirst(head, "").replaceFirst(tail, "");
            }
            byte[] certTmp = BasicNetSignAgent.base64Decode(b64Cert.trim());
            in = new ByteArrayInputStream(certTmp);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
        return (X509Certificate)cf.generateCertificate(in);
    }

    public static String getCertificateDetail(X509Certificate cert, int type) {
        return new ExtendInfoUtil().getCertificateDetail(cert, type);
    }

    public static String GetUserInfoByOid(X509Certificate certificate, String Oid) {
        return new ExtendInfoUtil().GetUserInfoByOid(certificate, Oid);
    }

    public static String getVersion() {
        return version;
    }

    public NetSignResult makeEnvelope(byte[] plainText, String subject, String sAlg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setEncCertDN(subject);
        req.setSymmetricalAlg(sAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult makeEnvelope(X509Certificate encCert, String sAlg, byte[] plainText) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setTransCert(true);
        req.setCert(NetSignAgentUtil.transcertificate(encCert));
        req.setSymmetricalAlg(sAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult makeMSEnvelope(byte[] plainText, String signSubject, String encSubject, String digestAlg, String sAlg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeMSEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setEncCertDN(encSubject);
        req.setSignCertDN(signSubject);
        req.setSymmetricalAlg(sAlg);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult makeMSEnvelope(String signSubject, X509Certificate encCert, String digestAlg, String sAlg, byte[] plainText) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeMSEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setTransCert(true);
        req.setCert(NetSignAgentUtil.transcertificate(encCert));
        req.setSignCertDN(signSubject);
        req.setSymmetricalAlg(sAlg);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public static byte[] makePlainTextWithFile(String fileName, byte[] filecontent) {
        byte[] fileNameBs = null;
        try {
            fileNameBs = fileName.getBytes("GBK");
        }
        catch (Exception e) {
            fileNameBs = fileName.getBytes();
        }
        byte[] str1 = "00000000".getBytes();
        byte[] str2 = "0".getBytes();
        byte[] strForm = "00000000".getBytes();
        int fileLen = filecontent.length;
        int nameLen = fileNameBs.length;
        str2 = Integer.toString(nameLen, 10).getBytes();
        byte[] str3 = Integer.toString(fileLen + nameLen + 8, 10).getBytes();
        byte[] StrFileSubTotal = new byte[16 + nameLen + filecontent.length];
        System.arraycopy(str1, 0, StrFileSubTotal, 0, 8 - str3.length);
        System.arraycopy(str3, 0, StrFileSubTotal, 8 - str3.length, str3.length);
        System.arraycopy(str1, 0, StrFileSubTotal, 8, 8 - str2.length);
        System.arraycopy(str2, 0, StrFileSubTotal, 16 - str2.length, str2.length);
        System.arraycopy(fileNameBs, 0, StrFileSubTotal, 16, fileNameBs.length);
        System.arraycopy(filecontent, 0, StrFileSubTotal, 16 + fileNameBs.length, filecontent.length);
        str2 = Integer.toString(StrFileSubTotal.length, 10).getBytes();
        byte[] strFinal = new byte[16 + StrFileSubTotal.length];
        System.arraycopy(strForm, 0, strFinal, 0, 8);
        System.arraycopy(str1, 0, strFinal, 8, 8 - str2.length);
        System.arraycopy(str2, 0, strFinal, 16 - str2.length, str2.length);
        System.arraycopy(StrFileSubTotal, 0, strFinal, 16, StrFileSubTotal.length);
        return strFinal;
    }

    public NetSignResult PBCDetachedSignature(byte[] plainText, String subject, byte[] pwd) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        req.setApiPasswd(pwd);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult PBCRAWSignature(byte[] plainText, String subject, byte[] pwd) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        req.setApiPasswd(pwd);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult pdfEncrypt(X509Certificate encCert, PDFParameters para) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("EncryptPDFByCertProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setCert(NetSignAgentUtil.transcertificate(encCert));
        if (para.getOwnerPassword() != null) {
            req.setPdfpasswd(para.getOwnerPassword());
        }
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.pdfEncryptResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult pdfSignature(PDFParameters para) throws NetSignAgentException, ServerProcessException {
        ArrayList pdfRequests;
        NSMessage req = NetSignAgentUtil.createMessage("PDFSignatureProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        if (para.getOwnerPassword() != null) {
            req.setPdfpasswd(para.getOwnerPassword());
        }
        if ((pdfRequests = para.getRectangles()) == null || pdfRequests.size() <= 0) {
            throw new NetSignAgentException(-1028, "Pdf signature rectangle is null");
        }
        req.setPDFSignatureRectangles(pdfRequests);
        req.setPdfImages(para.getImages());
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.pdfSignatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public ArrayList pdfVerify(PDFParameters para, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("PDFVerifyProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setTransCert(needCert);
        req.setPlainText(plainBytes);
        if (para.getOwnerPassword() != null) {
            req.setPdfpasswd(para.getOwnerPassword());
        }
        NSMessageOpt res = this.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.pdfVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawAfterwardsVerify(byte[] plainText, String signedText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawAfterwardsVerify(byte[] plainText, String signedText, String digestAlg, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        if (digestAlg != null && !"".equals(digestAlg)) {
            req.setDigestAlg(digestAlg);
        }
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawSignature(byte[] plainText, String subject, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        if (digestAlg != null && !"".equals(digestAlg)) {
            req.setDigestAlg(digestAlg);
        }
        req.setSignCertDN(subject);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, byte[] signedBytes, String tsaText, PublicKey publickey) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setPublicKey(NetSignAgentUtil.transpublickey(publickey));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, byte[] signedText, String tsaText, String certDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        byte[] signedBytes = signedText;
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setSignCertDN(certDN);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, byte[] signedBytes, String digestAlg, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        if (digestAlg != null && !"".equals(digestAlg)) {
            req.setDigestAlg(digestAlg);
        }
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, byte[] signedBytes, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, String signedText, String tsaText, PublicKey publickey) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setPublicKey(NetSignAgentUtil.transpublickey(publickey));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, String signedText, String tsaText, String certDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setSignCertDN(certDN);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, String signedText, String digestAlg, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        req.setDigestAlg(digestAlg);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(byte[] plainText, String signedText, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify4QLBKB(byte[] plainText, String signedText, String digestAlg, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyQLBKeyBusinessProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(BasicNetSignAgent.base64Decode(signedText));
        req.setDigestAlg(digestAlg);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult RAWVerify4UKey2G(byte[] plainText, byte[] signed, X509Certificate cert, String digestAlg, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(standard);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signed);
        req.setDigestAlg(digestAlg);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        req.setTransCert(true);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult RAWVerify4UKey2G(byte[] plainText, String signedText, X509Certificate cert, String digestAlg, String standard) throws NetSignAgentException, ServerProcessException {
        return this.RAWVerify4UKey2G(plainText, BasicNetSignAgent.base64Decode(signedText), cert, digestAlg, standard);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NSMessageOpt sendMsgAndCheck(NSMessage req) throws NetSignAgentException, ServerProcessException {
        NSMessageOpt resp = null;
        Socket conn = null;
        try {
            try {
                conn = this.sh.getSocket();
                MultiCommunicator mc = new MultiCommunicator(conn);
                mc.send(req);
                resp = (NSMessageOpt)mc.recv();
            }
            catch (Exception e) {
                this.sh.forceClose(conn);
                try {
                    conn = this.sh.newSocket();
                    MultiCommunicator mc = new MultiCommunicator(conn);
                    mc.send(req);
                    resp = (NSMessageOpt)mc.recv();
                }
                catch (Exception e2) {
                    SocketAddress sa = conn.getRemoteSocketAddress();
                    ConsoleLogger.logException(e2, "Send message to " + sa + " failed");
                    this.sh.forceClose(conn);
                    new NetSignAgentException(-1006, e.toString());
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.sh.close(conn);
            throw throwable;
        }
        {
            Object var7_11 = null;
            this.sh.close(conn);
        }
        BasicNetSignAgent.checkResult(resp);
        return resp;
    }

    public NetSignResult unstandardDetachedSignature(byte[] plainText, String subject, boolean useTSA, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult unstandardDetachedVerify(byte[] plainText, String signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public String VerifyCertChainProcessor(String certDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertChainProcessor");
        req.setSignCertDN(certDN);
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        StringBuffer sb = new StringBuffer();
        sb.append(resp.getSignIssuerSubject()).append(",");
        sb.append(resp.getSignEndtime()).append(",");
        sb.append(resp.getSignSerNumber()).append(",");
        sb.append(resp.getSignStartTime()).append(",");
        sb.append(resp.getCert()).append(",");
        sb.append(resp.getResult());
        return sb.toString();
    }

    public NetSignResult verifyCertificate(X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertProcessor");
        req.setTransCert(true);
        req.setCert(cert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Sign_Subject", res.getSignSubject());
        map.put("Sign_Ser_Number", res.getSignSerNumber());
        map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
        map.put("Sign_Start_Time", res.getSignStartTime());
        map.put("Sign_End_Time", res.getSignEndtime());
        return new NetSignResult(map);
    }

    public NetSignResult XMLAlipaySign(byte[] xml, String subjectDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("XMLAlipaySignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (subjectDN != null && !subjectDN.equals("")) {
            req.setSignCertDN(subjectDN);
        }
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public ArrayList XMLAlipayVerify(byte[] xml, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("XMLAlipayVerifyProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        req.setCert(cert);
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.xmlVerifyResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public NetSignResult XMLDetachedSign(byte[] xml, boolean needCanonial, String tbsID, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLDatechedSignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        req.setXmlReferenceURI(tbsID);
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public NetSignResult XMLDetachedSign(byte[] xml, boolean needCanonial, String[] tbsID, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLDatechedSignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tbsID.length) {
            sb.append(tbsID[i]);
            if (i < tbsID.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        req.setXmlReferenceURI(sb.toString());
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public NetSignResult XMLEnvelopedSign(byte[] xml, boolean needCanonial, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLEnvelopedSignProcessor");
        req.setNeedCanonial(needCanonial);
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public NetSignResult XMLEnvelopingSign(byte[] xml, boolean needCanonial, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLEnvelopingSignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public ArrayList XMLSignatureAfterwardsVerify(byte[] xml, boolean needCanonical, boolean needCert) throws NetSignAgentException, ServerProcessException {
        if (needCanonical) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLSignatureAfterwardsVerifyProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        req.setTransCert(needCert);
        req.setNeedCanonial(needCanonical);
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.xmlVerifyResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public ArrayList XMLSignatureVerify(byte[] xml, boolean needCanonical, boolean needCert) throws NetSignAgentException, ServerProcessException {
        if (needCanonical) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLSignatureVerifyProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        req.setTransCert(needCert);
        req.setNeedCanonial(needCanonical);
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.xmlVerifyResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public NetSignResult XMLTenPaySign(byte[] xml, String tbsID, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("XMLTenPaySignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        req.setXmlReferenceURI(tbsID);
        NSMessageOpt resp = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult(resp);
        BasicNetSignAgent.freeObjects(req, resp);
        xml = null;
        return result;
    }

    public NetSignResult detachedSignature(InputStream plainText, String signSubject, String digestAlg) throws NetSignAgentException, ServerProcessException {
        NSMessageOpt resp = this.getSignCert(signSubject, digestAlg, null, false);
        digestAlg = resp.getDigestAlg();
        byte[] digestValue = BasicNetSignAgent.computeStreamDigest(resp, plainText);
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignHashProcessor");
        req.setSignCertDN(signSubject);
        req.setPlainText(digestValue);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        return NetSignAgentUtil.signatureResult(res);
    }

    public NetSignResult detachedVerify(InputStream plaintext, String signedText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        String digestAlg = null;
        X509Certificate cert = null;
        byte[] cryptoBytes = null;
        try {
            cryptoBytes = Base64.decode(signedText);
            PKCS7SignedData p7 = PKCS7SignedDataParser.parse(cryptoBytes, "INFOSEC");
            String digestAlgOID = p7.getDigestAlgOid();
            digestAlg = (String)NetSignAgentUtil.digestOIDName.get(digestAlgOID);
            cert = p7.getSignCert();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new NetSignAgentException(-1026, "Decode signedtext failed:" + e.toString());
        }
        NSMessageOpt resp = this.getSignCert(null, digestAlg, cert, false);
        byte[] digestValue = BasicNetSignAgent.computeStreamDigest(resp, plaintext);
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyHashProcessor");
        req.setPlainText(digestValue);
        req.setCryptoText(cryptoBytes);
        req.setTransCert(false);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        if (needCert) {
            res.setTransCert(true);
            res.setCert(cert);
        }
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawSignature(InputStream plainText, String signSubject, String digestAlg) throws NetSignAgentException, ServerProcessException {
        NSMessageOpt resp = this.getSignCert(signSubject, digestAlg, null, false);
        digestAlg = resp.getDigestAlg();
        byte[] digestValue = BasicNetSignAgent.computeStreamDigest(resp, plainText);
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignHashProcessor");
        req.setPlainText(digestValue);
        req.setDigestAlg(digestAlg);
        req.setSignCertDN(signSubject);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    public NetSignResult rawVerify(InputStream plainText, String signature, X509Certificate cert, String digestAlg) throws NetSignAgentException, ServerProcessException {
        byte[] digestValue = null;
        NSMessageOpt resp = this.getSignCert(null, digestAlg, cert, false);
        digestAlg = resp.getDigestAlg();
        digestValue = BasicNetSignAgent.computeStreamDigest(resp, plainText);
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyHashProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signature);
        req.setCryptoText(signedBytes);
        req.setPlainText(digestValue);
        req.setDigestAlg(digestAlg);
        req.setCert(cert);
        NSMessageOpt res = this.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        BasicNetSignAgent.freeObjects(req, res);
        return result;
    }

    private NSMessageOpt getSignCert(String subject, String digestAlg, X509Certificate cert, boolean needCert) throws NetSignAgentException, ServerProcessException {
        if (cert != null && cert.getPublicKey() instanceof RSAPublicKey && digestAlg != null) {
            NSMessageOpt resp = new NSMessageOpt();
            resp.setDigestAlg(digestAlg);
            resp.setCert(cert);
            return resp;
        }
        NSMessage req = NetSignAgentUtil.createMessage("GetSignCertProcessor");
        req.setSignCertDN(subject);
        req.setCert(cert);
        req.setDigestAlg(digestAlg);
        req.setTransCert(needCert);
        return this.sendMsgAndCheck(req);
    }

    private static byte[] computeStreamDigest(NSMessageOpt resp, InputStream plainText) throws NetSignAgentException {
        String digestAlg = resp.getDigestAlg();
        byte[] digestValue = null;
        byte[] Z = resp.getHashValue();
        if (Z == null) {
            Z = new byte[]{};
        }
        try {
            digestValue = digestAlg.equals("SM3") ? OSCCAMessageDigest.SM3Digest(Z, plainText) : OSCCAMessageDigest.SHADigest(Z, plainText, digestAlg);
            return digestValue;
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new NetSignAgentException(-1023, "Read plaintext failed:" + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new NetSignAgentException(-1023, "Digest failed:" + e.toString());
        }
    }
}

