/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.newcommunitor;

import cn.com.infosec.jce.logger.ConsoleLogger;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignService;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorPool;
import cn.com.infosec.netsign.agent.newcommunitor.ThinCommunitor;
import cn.com.infosec.netsign.agent.service.NSPSService;
import cn.com.infosec.netsign.agent.service.NSService;
import cn.com.infosec.netsign.agent.service.ServiceList;
import cn.com.infosec.netsign.agent.service.ServiceManager;
import cn.com.infosec.netsign.agent.service.ServiceSelector;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.pool.Pool;

public class CommunitorManager {
    private ThinCommunitor conn;
    private CommunitorPool pool;
    private static long lastCheck = 0L;
    private ServiceManager sm;
    private static Pool sendMsgLock = null;

    static {
        try {
            if (NetSignAgentRes.getMaxParallelThread() > 0) {
                sendMsgLock = new Pool("cn.com.infosec.netsign.pool.SamplePoolable", NetSignAgentRes.getMaxParallelThread(), null);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public CommunitorManager(boolean isUsingCommonServicemanager) {
        if (NetSignAgentRes.isUseConnectionPool()) {
            this.pool = new CommunitorPool();
        }
        this.conn = new ThinCommunitor();
        this.sm = new ServiceManager(isUsingCommonServicemanager);
    }

    public void buildCommunitorPool() {
        if (this.pool != null && NetSignAgentRes.isUseConnectionPool()) {
            this.pool = new CommunitorPool();
        }
    }

    public void addService(NSService s) {
        this.sm.addService(s);
    }

    public void addService(NetSignService s) {
        this.sm.addService(s);
    }

    private void setPassword(NSMessage msg, NSService s) {
        if (s instanceof NSPSService) {
            NSPSService pss = (NSPSService)s;
            msg.setApiPasswd(pss.getApiPasswd());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NSMessageOpt[] sendAll(NSMessage msg) {
        ServiceList sl = this.sm.getInnerAllService();
        if (sl == null) {
            return new NSMessageOpt[0];
        }
        int size = sl.size();
        NSMessageOpt[] results = new NSMessageOpt[size];
        int i = 0;
        while (i < size) {
            Object var11_15;
            NSService s = sl.getService(i);
            this.setPassword(msg, s);
            ThinCommunitor tc = null;
            try {
                try {
                    tc = new ThinCommunitor(s);
                    results[i] = tc.sendMessage(msg);
                }
                catch (NetSignAgentException e) {
                    NSMessageOpt tmpMsg;
                    if (tc != null) {
                        tc.close();
                    }
                    try {
                        Thread.sleep(50L);
                        if (tc == null) {
                            tc = new ThinCommunitor(s);
                        } else {
                            tc.openConnection();
                        }
                        results[i] = tc.sendMessage(msg);
                    }
                    catch (NetSignAgentException nsae) {
                        tmpMsg = new NSMessageOpt();
                        tmpMsg.setResult(e.getErrorCode());
                        tmpMsg.setErrMsg(e.getMessage());
                        results[i] = tmpMsg;
                    }
                    catch (Exception oe) {
                        tmpMsg = new NSMessageOpt();
                        tmpMsg.setResult(-9999);
                        tmpMsg.setErrMsg(oe.toString());
                        results[i] = tmpMsg;
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    NSMessageOpt tmpMsg = new NSMessageOpt();
                    tmpMsg.setResult(-9999);
                    tmpMsg.setErrMsg(e.toString());
                    results[i] = tmpMsg;
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                var11_15 = null;
                results[i].setAddress(s.getIp());
                if (tc != null) {
                    tc.close();
                }
                throw throwable;
            }
            {
                var11_15 = null;
            }
            results[i].setAddress(s.getIp());
            if (tc != null) {
                tc.close();
            }
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NSMessageOpt sendMessageUsingShrotConnection(NSMessage msg) throws NetSignAgentException {
        block18: {
            this.checkAllServices();
            resp = null;
            selector = this.sm.select();
            lock = null;
            if (CommunitorManager.sendMsgLock != null) {
                try {
                    lock = CommunitorManager.sendMsgLock.getObject();
                }
                catch (Exception var5_5) {
                    // empty catch block
                }
            }
            tc = this.createNewThinCommunitor(selector);
            try {
                try {
                    resp = tc.sendMessage(msg);
                }
                catch (Exception e) {
                    tc.close();
                    try {
                        tc.openConnection();
                        resp = tc.sendMessage(msg);
                    }
                    catch (Exception e2) {
                        tc.close();
                        selector = this.sm.select();
                        var10_9 = this.sendMsgFailedHandle(msg, tc, selector, e2);
                        var8_10 = null;
                        if (CommunitorManager.sendMsgLock != null && lock != null) {
                            try {
                                CommunitorManager.sendMsgLock.freeObject(lock);
                            }
                            catch (Exception var11_13) {
                                // empty catch block
                            }
                        }
                        tc.close();
                        return var10_9;
                    }
                }
            }
            catch (Throwable var9_16) {
                block17: {
                    var8_11 = null;
                    if (CommunitorManager.sendMsgLock != null && lock != null) {
                        ** try [egrp 4[TRYBLOCK] [5 : 129->140)] { 
lbl42:
                        // 1 sources

                        CommunitorManager.sendMsgLock.freeObject(lock);
                        break block17;
lbl44:
                        // 1 sources

                        catch (Exception var11_14) {
                            // empty catch block
                        }
                    }
                }
                tc.close();
                throw var9_16;
            }
            {
                var8_12 = null;
                if (CommunitorManager.sendMsgLock == null || lock == null) break block18;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 129->140)] { 
lbl52:
            // 1 sources

            CommunitorManager.sendMsgLock.freeObject(lock);
            break block18;
lbl54:
            // 1 sources

            catch (Exception var11_15) {
                // empty catch block
            }
        }
        tc.close();
        return resp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NSMessageOpt sendMessageUsingShrotConnection(NSMessage msg, int serviceIndex) throws NetSignAgentException {
        block13: {
            this.checkAllServices();
            resp = null;
            lock = null;
            if (CommunitorManager.sendMsgLock != null) {
                try {
                    lock = CommunitorManager.sendMsgLock.getObject();
                }
                catch (Exception var5_5) {
                    // empty catch block
                }
            }
            tc = new ThinCommunitor(this.sm.getAllService().getService(serviceIndex));
            try {
                try {
                    resp = tc.sendMessage(msg);
                }
                catch (Exception e) {
                    tc.close();
                    tc.openConnection();
                    resp = tc.sendMessage(msg);
                }
            }
            catch (Throwable var8_8) {
                var7_9 = null;
                if (CommunitorManager.sendMsgLock != null && lock != null) {
                    try {
                        CommunitorManager.sendMsgLock.freeObject(lock);
                    }
                    catch (Exception var9_11) {
                        // empty catch block
                    }
                }
                tc.close();
                throw var8_8;
            }
            {
                var7_10 = null;
                if (CommunitorManager.sendMsgLock == null || lock == null) break block13;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 101->112)] { 
lbl35:
            // 1 sources

            CommunitorManager.sendMsgLock.freeObject(lock);
            break block13;
lbl37:
            // 1 sources

            catch (Exception var9_12) {
                // empty catch block
            }
        }
        tc.close();
        return resp;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NSMessageOpt sendMessageUsingLongConnection(NSMessage msg) throws NetSignAgentException {
        this.checkAllServices();
        resp = null;
        selector = this.sm.select();
        lock = null;
        if (CommunitorManager.sendMsgLock != null) {
            try {
                lock = CommunitorManager.sendMsgLock.getObject();
            }
            catch (Exception var5_5) {
                // empty catch block
            }
        }
        tc = this.getCommunitor(selector);
        try {
            try {
                resp = tc.sendMessage(msg);
            }
            catch (Exception e) {
                tc.close();
                try {
                    tc.openConnection();
                    resp = tc.sendMessage(msg);
                }
                catch (Exception e2) {
                    tc.close();
                    selector = this.sm.select();
                    var10_9 = this.sendMsgFailedHandle(msg, tc, selector, e2);
                    var8_10 = null;
                    if (NetSignAgentRes.isUseConnectionPool()) {
                        this.pool.freeCommunitor(tc);
                    }
                    if (CommunitorManager.sendMsgLock == null) return var10_9;
                    if (lock == null) return var10_9;
                    try {
                        CommunitorManager.sendMsgLock.freeObject(lock);
                        return var10_9;
                    }
                    catch (Exception var11_13) {
                        // empty catch block
                    }
                    return var10_9;
                }
            }
        }
        catch (Throwable var9_16) {
            var8_11 = null;
            if (NetSignAgentRes.isUseConnectionPool()) {
                this.pool.freeCommunitor(tc);
            }
            if (CommunitorManager.sendMsgLock == null) throw var9_16;
            if (lock == null) throw var9_16;
            ** try [egrp 4[TRYBLOCK] [5 : 144->155)] { 
lbl46:
            // 1 sources

            CommunitorManager.sendMsgLock.freeObject(lock);
            throw var9_16;
lbl48:
            // 1 sources

            catch (Exception var11_14) {
                // empty catch block
            }
            throw var9_16;
        }
        {
            var8_12 = null;
        }
        if (NetSignAgentRes.isUseConnectionPool()) {
            this.pool.freeCommunitor(tc);
        }
        if (CommunitorManager.sendMsgLock == null) return resp;
        if (lock == null) return resp;
        try {}
        catch (Exception var11_15) {
            return resp;
        }
        CommunitorManager.sendMsgLock.freeObject(lock);
        return resp;
    }

    private NSMessageOpt sendMsgFailedHandle(NSMessage msg, ThinCommunitor tc, ServiceSelector selector, Exception exception) throws NetSignAgentException {
        NSService s = null;
        while ((s = selector.nextService()) != null) {
            try {
                tc.setService(s);
                return tc.sendMessage(msg);
            }
            catch (Exception e) {
                exception = e;
                ConsoleLogger.logException((Throwable)e, (String)e.getMessage());
                if (tc == null) continue;
                tc.close();
            }
        }
        if (exception instanceof NetSignAgentException) {
            throw (NetSignAgentException)exception;
        }
        throw new NetSignAgentException(-1006, "all service are inavailable");
    }

    private ThinCommunitor getCommunitor(ServiceSelector selector) throws NetSignAgentException {
        if (NetSignAgentRes.isUseConnectionPool()) {
            return this.getPoolCommunitor(selector);
        }
        this.getThinCommunitor(selector);
        return this.conn;
    }

    private ThinCommunitor getPoolCommunitor(ServiceSelector selector) throws NetSignAgentException {
        int connMode = NetSignAgentRes.getConnectionMode();
        ThinCommunitor tc = this.pool.getCommunitor();
        if (tc.getService() != null) {
            NSService nss;
            if (connMode == 1 && (nss = selector.nextService()) != null && !nss.equals(tc.getService())) {
                tc.close();
                selector.reset();
                ThinCommunitor.createThinCommunitor(selector, tc);
            }
        } else {
            ThinCommunitor.createThinCommunitor(selector, tc);
        }
        return tc;
    }

    private void getThinCommunitor(ServiceSelector selector) throws NetSignAgentException {
        int connMode = NetSignAgentRes.getConnectionMode();
        if (this.conn != null && this.conn.getService() != null) {
            NSService nss;
            if (connMode == 1 && (nss = (selector = this.sm.select()).nextService()) != null && !nss.equals(this.conn.getService())) {
                this.conn.close();
                selector.reset();
                ThinCommunitor.createThinCommunitor(selector, this.conn);
            }
        } else {
            ThinCommunitor.createThinCommunitor(selector, this.conn);
        }
    }

    private ThinCommunitor createNewThinCommunitor(ServiceSelector selector) throws NetSignAgentException {
        int connMode = NetSignAgentRes.getConnectionMode();
        ThinCommunitor tc = new ThinCommunitor();
        ThinCommunitor.createThinCommunitor(selector, tc);
        return tc;
    }

    private synchronized void checkAllServices() {
        if (NetSignAgentRes.isAutoTest()) {
            long x = System.currentTimeMillis() - lastCheck;
            if (x < 0L) {
                x = 0L;
            }
            if (x >= NetSignAgentRes.getTestInterval()) {
                Thread t = new Thread(new ServiceTester());
                t.start();
                lastCheck = System.currentTimeMillis();
            }
        }
    }

    public void closeCommunitor() {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    class ServiceTester
    implements Runnable {
        ServiceTester() {
        }

        public void run() {
            NSMessage msg = NetSignAgentUtil.createMessage("HeartbeatProcessor");
            CommunitorManager.this.sendAll(msg);
        }
    }
}

