/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.encryption.SM4;
import cn.com.infosec.oscca.encryption.SM4ECB;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;

public class TestSM4 {
    public static void main(String[] args) throws Exception {
        ConsoleLogger.isDebug = true;
        TestSM4.testSM4ECB();
    }

    private static void testSM4ECB() throws Exception {
        SecureRandom sr = new SecureRandom();
        byte[] key = new byte[16];
        sr.nextBytes(key);
        ConsoleLogger.logBinary("key", key);
        byte[] plain = "12345678".getBytes();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SM4ECB ecb = new SM4ECB(SM4ECB.ENC_MOD);
        ecb.init(key);
        out.write(ecb.update(plain));
        out.write(ecb.doFinal());
        byte[] cipher = out.toByteArray();
        ConsoleLogger.logBinary("cipher1", cipher);
        cipher = SM4.sm4_ecb_encrypt(plain, key);
        ConsoleLogger.logBinary("cipher2", cipher);
        out = new ByteArrayOutputStream();
        ecb = new SM4ECB(SM4ECB.DEC_MOD);
        ecb.init(key);
        out.write(ecb.update(cipher));
        out.write(ecb.doFinal());
        plain = out.toByteArray();
        ConsoleLogger.logString(new String(plain));
    }
}

