/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.json;

import cn.com.infosec.netsign.json.JsonObject;
import cn.com.infosec.netsign.json.JsonValue;
import cn.com.infosec.netsign.json.JsonValueArray;
import cn.com.infosec.netsign.json.JsonValueBoolean;
import cn.com.infosec.netsign.json.JsonValueNull;
import cn.com.infosec.netsign.json.JsonValueNumber;
import cn.com.infosec.netsign.json.JsonValueObject;
import cn.com.infosec.netsign.json.JsonValueString;
import java.math.BigDecimal;

public class JsonParser {
    public static final char[] spaceChars = new char[]{' ', '\t', '\r', '\n'};
    public static final char objectStart = '{';
    public static final char objectEnd = '}';
    public static final char arrayStart = '[';
    public static final char arrayEnd = ']';
    public static final char splitNameValue = ':';
    public static final char splitPair = ',';
    public static final char quote = '\"';
    public static final char rsolidus = '\\';
    public static final String jsonTrue = "TRUE";
    public static final String jsonFalse = "FALSE";
    public static final String jsonNull = "NULL";
    private int indexNow = 0;
    private String encoding = "UTF-8";
    private char[] jsonStr;

    public JsonParser(String encoding) {
        this.encoding = encoding;
    }

    public JsonObject parse(char[] jsonStr) {
        this.jsonStr = jsonStr;
        return this.parseObject(0);
    }

    public JsonObject parseObject(int start) {
        this.indexNow = this.skipSpace(start);
        if (this.jsonStr[this.indexNow] != '{') {
            return null;
        }
        ++this.indexNow;
        JsonObject jo = new JsonObject();
        while (true) {
            this.indexNow = this.skipSpace(this.indexNow);
            if (this.jsonStr[this.indexNow] == '\"') {
                int end = this.findKeyChar('\"', this.indexNow + 1);
                if (end < 0) {
                    return null;
                }
                char[] namebs = new char[end - this.indexNow - 1];
                System.arraycopy(this.jsonStr, this.indexNow + 1, namebs, 0, namebs.length);
                this.indexNow = end;
                this.indexNow = this.findKeyChar(':', this.indexNow);
                JsonValue value = this.parseValue(this.indexNow + 1);
                if (value == null) {
                    return null;
                }
                try {
                    jo.put(new String(namebs), value);
                }
                catch (Exception exception) {}
                continue;
            }
            if (this.jsonStr[this.indexNow] != ',') break;
            ++this.indexNow;
        }
        if (this.jsonStr[this.indexNow] == '}') {
            return jo;
        }
        return null;
    }

    JsonValue parseValue(int start) {
        this.indexNow = this.skipSpace(start);
        switch (this.jsonStr[this.indexNow]) {
            case '\"': {
                return this.parseStringValue(this.indexNow);
            }
            case '[': {
                return this.parseArrayValue(this.indexNow);
            }
            case 't': {
                return this.parseBooleanValue(this.indexNow);
            }
            case 'f': {
                return this.parseBooleanValue(this.indexNow);
            }
            case 'T': {
                return this.parseBooleanValue(this.indexNow);
            }
            case 'F': {
                return this.parseBooleanValue(this.indexNow);
            }
            case 'n': {
                return this.parseNullValue(this.indexNow);
            }
            case 'N': {
                return this.parseNullValue(this.indexNow);
            }
            case '{': {
                return this.parseObjectValue(this.indexNow);
            }
        }
        return this.parseNumberValue(this.indexNow);
    }

    JsonValue parseNumberValue(int start) {
        char b = this.jsonStr[start];
        if ((b < '0' || b > '9') && b != '-') {
            return null;
        }
        int x = start + 1;
        while (x < this.jsonStr.length - start) {
            b = this.jsonStr[x];
            if ((b < '0' || b > '9') && b != '+' && b != 'e' && b != 'E' && b != '.') break;
            ++x;
        }
        char[] bs = new char[x - start];
        System.arraycopy(this.jsonStr, start, bs, 0, bs.length);
        try {
            BigDecimal bd = new BigDecimal(new String(bs));
            JsonValueNumber jvn = new JsonValueNumber();
            jvn.setValue(bd);
            this.indexNow = x;
            return jvn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    JsonValue parseArrayValue(int start) {
        ++start;
        JsonValueArray jva = new JsonValueArray();
        while (true) {
            this.indexNow = this.skipSpace(start);
            if (this.jsonStr[this.indexNow] == ']') break;
            if (this.jsonStr[this.indexNow] == ',') continue;
            jva.add(this.parseValue(this.indexNow));
        }
        return jva;
    }

    JsonValue parseObjectValue(int start) {
        JsonObject jo = this.parseObject(this.indexNow);
        if (jo != null) {
            JsonValueObject jvo = new JsonValueObject();
            jvo.setValue(jo);
            ++this.indexNow;
            return jvo;
        }
        return null;
    }

    JsonValue parseNullValue(int start) {
        JsonValueNull jvb = new JsonValueNull();
        byte[] bs = new byte[4];
        System.arraycopy(this.jsonStr, start, bs, 0, bs.length);
        String str = new String(bs).toUpperCase();
        if (!str.equals(jsonNull)) {
            return null;
        }
        this.indexNow = start + bs.length;
        return jvb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JsonValue parseBooleanValue(int start) {
        JsonValueBoolean jvb = new JsonValueBoolean();
        if (this.jsonStr[start] == 'f' || this.jsonStr[start] == 'F') {
            byte[] bs = new byte[5];
            System.arraycopy(this.jsonStr, start, bs, 0, bs.length);
            String str = new String(bs).toUpperCase();
            if (!str.equals(jsonFalse)) return null;
            jvb.setValue(Boolean.FALSE);
            this.indexNow = start + bs.length;
            return jvb;
        } else {
            byte[] bs = new byte[4];
            System.arraycopy(this.jsonStr, start, bs, 0, bs.length);
            String str = new String(bs).toUpperCase();
            if (!str.equals(jsonTrue)) return null;
            jvb.setValue(Boolean.TRUE);
            this.indexNow = start + bs.length;
        }
        return jvb;
    }

    JsonValue parseStringValue(int start) {
        JsonValueString jvs = new JsonValueString();
        int end = this.findKeyChar('\"', start + 1);
        char[] value = new char[end - start - 1];
        System.arraycopy(this.jsonStr, start + 1, value, 0, value.length);
        try {
            String str = new String(value);
            jvs.setValue(str);
            jvs.setRealString(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.indexNow = end + 1;
        return jvs;
    }

    String parseRealString(String str) {
        char[] cs = str.toCharArray();
        int start = 0;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == '\\') {
                buf.append(cs, start, start - i);
                switch (cs[++i]) {
                    case 'n': {
                        buf.append("\n");
                        start += 2;
                        break;
                    }
                    case 'b': {
                        buf.append("\b");
                        start += 2;
                        break;
                    }
                    case 'f': {
                        buf.append("\f");
                        start += 2;
                        break;
                    }
                    case 'r': {
                        buf.append("\r");
                        start += 2;
                        break;
                    }
                    case 't': {
                        buf.append("\t");
                        start += 2;
                        break;
                    }
                    default: {
                        buf.append(cs[i]);
                        start += 2;
                    }
                }
            }
            ++i;
        }
        buf.append(cs, start, cs.length - start);
        return buf.toString();
    }

    int skipSpace(int start) {
        if (this.jsonStr[start] == spaceChars[0] || this.jsonStr[start] == spaceChars[1] || this.jsonStr[start] == spaceChars[2] || this.jsonStr[start] == spaceChars[3]) {
            return this.skipSpace(++start);
        }
        return start;
    }

    int findKeyChar(char tbf, int start) {
        while (start < this.jsonStr.length) {
            if (this.jsonStr[start] == tbf) {
                int x = 0;
                while (x < start) {
                    if (this.jsonStr[start - x - 1] != '\\') break;
                    ++x;
                }
                if (x % 2 == 0) {
                    return start;
                }
            }
            ++start;
        }
        return -1;
    }
}

