/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.pure.impl;

import cfca.sadk.tls.pure.SymEncryption;
import cfca.sadk.tls.sun.security.ssl.JSSEProvider;
import cryptokit.jni.JNISymAlg;
import java.nio.ByteBuffer;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class JNIEncryption
implements SymEncryption {
    private int mode;
    private JNISymAlg jni = new JNISymAlg();

    JNIEncryption() {
    }

    @Override
    public void init(int mode, SecretKey key, IvParameterSpec iv, SecureRandom random) throws SecurityException {
        byte[] k;
        this.mode = mode;
        try {
            k = key.getEncoded();
        }
        catch (Exception e) {
            throw new SecurityException("invalid key", e);
        }
        byte[] v = iv.getIV();
        try {
            switch (mode) {
                case 1: {
                    this.jni.encryptInit(JNISymAlg.NID_ChinaSM4_CBC, k, v);
                    break;
                }
                case 2: {
                    this.jni.encryptInit(JNISymAlg.NID_ChinaSM4_CBC, k, v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("invalid opmode");
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException("engineInit failure", e);
        }
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws SecurityException {
        int len = 0;
        try {
            switch (this.mode) {
                case 1: {
                    len = this.jni.encryptProcess(input, inputOffset, inputLen, output, outputOffset);
                    break;
                }
                case 2: {
                    len = this.jni.decryptProcess(input, inputOffset, inputLen, output, outputOffset);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("invalid opmode");
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException("engineInit failure", e);
        }
        return len;
    }

    @Override
    public Provider getProvider() {
        return JSSEProvider.getInstance();
    }

    @Override
    public int update(ByteBuffer dup, ByteBuffer bb) throws SecurityException {
        return 0;
    }

    @Override
    public void doFinal() throws SecurityException {
    }
}

