/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import java.io.IOException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;

public final class DistinguishedName {
    byte[] name;

    public DistinguishedName(X500Principal dn) {
        this.name = dn.getEncoded();
    }

    public DistinguishedName(HandshakeInStream in) throws IOException {
        this.name = in.getBytes16();
    }

    public X500Principal getX500Principal() throws IOException {
        try {
            return new X500Principal(this.name);
        }
        catch (IllegalArgumentException e) {
            throw (SSLProtocolException)new SSLProtocolException(e.getMessage()).initCause(e);
        }
    }

    public int length() {
        return 2 + this.name.length;
    }

    public void write(HandshakeOutStream out) throws IOException {
        out.putBytes16(this.name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append('<');
        builder.append(new X500Principal(this.name));
        builder.append('>');
        return builder.toString();
    }
}

