/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.InputRecord;
import cfca.sadk.tls.sun.security.ssl.sec.HandshakeHash;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLException;

public final class HandshakeInStream
extends InputStream {
    InputRecord record = new InputRecord();

    HandshakeInStream(HandshakeHash handshakeHash) {
        this.record.setHandshakeHash(handshakeHash);
    }

    @Override
    public int available() {
        return this.record.available();
    }

    @Override
    public int read() throws IOException {
        int n = this.record.read();
        if (n == -1) {
            throw new SSLException("Unexpected end of handshake data");
        }
        return n;
    }

    @Override
    public int read(byte[] out, int off, int len) throws IOException {
        int n = this.record.read(out, off, len);
        if (n != len) {
            throw new SSLException("Unexpected end of handshake data");
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.record.skip(n);
    }

    @Override
    public void mark(int readlimit) {
        this.record.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.record.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public final int getInt8() throws IOException {
        return this.read();
    }

    public final int getInt16() throws IOException {
        return this.read() << 8 | this.read();
    }

    public final int getInt24() throws IOException {
        return this.read() << 16 | this.read() << 8 | this.read();
    }

    public final int getInt32() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public final byte[] getBytes8() throws IOException {
        int len = this.getInt8();
        return this.getBytes(len);
    }

    public final byte[] getBytes16() throws IOException {
        int len = this.getInt16();
        return this.getBytes(len);
    }

    public final byte[] getBytes24() throws IOException {
        int len = this.getInt24();
        return this.getBytes(len);
    }

    final void incomingRecord(InputRecord in) throws IOException {
        this.record.queueHandshake(in);
    }

    final void digestNow() {
        this.record.doHashes();
    }

    final void ignore(int n) {
        this.record.ignore(n);
    }

    private final byte[] getBytes(int length) throws SSLException, IOException {
        if (length > this.available()) {
            throw new SSLException("Not enough data to fill declared vector size");
        }
        byte[] value = new byte[length];
        this.read(value, 0, length);
        return value;
    }
}

