/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import java.io.IOException;

public final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    public static final int LIMIT_MAX_VALUE = 65535;
    public static final int LIMIT_MIN_VALUE = 0;
    static final ProtocolVersion NONE = new ProtocolVersion(-1, "NONE");
    static final ProtocolVersion SSL20Hello = new ProtocolVersion(2, "SSLv2Hello");
    public static final ProtocolVersion TLS11SM;
    static final ProtocolVersion MIN;
    static final ProtocolVersion MAX;
    public static final ProtocolVersion DEFAULT;
    public final int version;
    public final byte major;
    public final byte minor;
    final String name;

    private ProtocolVersion(int version, String name) {
        this.version = version;
        this.major = (byte)(version >>> 8);
        this.minor = (byte)(version & 0xFF);
        this.name = name;
    }

    private static ProtocolVersion valueOf(int v) {
        if (v == ProtocolVersion.TLS11SM.version) {
            return TLS11SM;
        }
        int major = v >>> 8 & 0xFF;
        int minor = v & 0xFF;
        return new ProtocolVersion(v, "Unknown-" + major + "." + minor);
    }

    public static ProtocolVersion valueOf(int major, int minor) {
        int v = (major &= 0xFF) << 8 | (minor &= 0xFF);
        return ProtocolVersion.valueOf(v);
    }

    public static ProtocolVersion valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Protocol cannot be null");
        }
        if (name.equals(ProtocolVersion.TLS11SM.name)) {
            return TLS11SM;
        }
        throw new IllegalArgumentException(name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ProtocolVersion protocolVersion) {
        return this.version - protocolVersion.version;
    }

    public static ProtocolVersion decodedFrom(HandshakeInStream in) throws IOException {
        return ProtocolVersion.valueOf(in.getInt16());
    }

    public final boolean isChinaTLS11() {
        return this.major == ProtocolVersion.TLS11SM.major;
    }

    public final boolean isTLS11() {
        return this.isChinaTLS11();
    }

    static {
        MIN = TLS11SM = new ProtocolVersion(Debugger.debugGmsslVersion ? 769 : 257, "GMTLSv1.1");
        MAX = TLS11SM;
        DEFAULT = TLS11SM;
    }
}

