/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialParameters;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterials;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretGenerator;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfGenerator;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TlsKeyMaterialGenerator
implements TlsKeyMaterialsConstants {
    protected TlsKeyMaterialGenerator() {
    }

    protected TlsKeyMaterials generateWorkKeys(TlsKeyMaterialParameters params) throws GeneralSecurityException {
        if (params == null || params.getMasterSecret() == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsKeyMaterialParameters"));
        }
        if (!"RAW".equals(params.getMasterSecret().getFormat())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeRAW", "TlsKeyMaterialParameters#MasterSecret"));
        }
        int protocolVersion = params.getMajorVersion() << 8 | params.getMinorVersion();
        if (!TlsMasterSecretGenerator.hasVersion(protocolVersion)) {
            throw new InvalidAlgorithmParameterException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
        }
        byte[] masterSecret = params.getMasterSecret().getEncoded();
        if (masterSecret == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "masterSecret"));
        }
        byte[] clientRandom = params.getClientRandom();
        if (clientRandom == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "clientRandom"));
        }
        byte[] serverRandom = params.getServerRandom();
        if (serverRandom == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "serverRandom"));
        }
        byte[] bothRandom = TlsKeyMaterialsTools.concat(serverRandom, clientRandom);
        HashPRF prf = params.hashPRF();
        int macLength = params.getMacKeyLength();
        int expandedKeyLength = params.getExpandedCipherKeyLength();
        boolean isExportable = expandedKeyLength != 0;
        int keyLength = params.getCipherKeyLength();
        int ivLength = params.getIvLength();
        int keyBlockLen = macLength + keyLength + (isExportable ? 0 : ivLength) << 1;
        byte[] keyBlock = this.generateKeyBlock(protocolVersion, masterSecret, bothRandom, serverRandom, clientRandom, keyBlockLen, prf);
        TlsKeyMaterials keyMaterials = new TlsKeyMaterials();
        int offset = 0;
        if (macLength != 0) {
            keyMaterials.clientMacKey = TlsKeyMaterialGenerator.buildSecretKey(keyBlock, offset, macLength, "Mac");
            keyMaterials.serverMacKey = TlsKeyMaterialGenerator.buildSecretKey(keyBlock, offset += macLength, macLength, "Mac");
            offset += macLength;
        }
        if (keyLength != 0) {
            String cipherAlgorithm = params.getCipherAlgorithm();
            byte[] clientKeyBytes = TlsKeyMaterialsTools.copyBytes(keyBlock, offset, keyLength);
            byte[] serverKeyBytes = TlsKeyMaterialsTools.copyBytes(keyBlock, offset += keyLength, keyLength);
            offset += keyLength;
            if (isExportable) {
                throw new RuntimeException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.mustNotNegotiating"));
            }
            this.setKeyMaterials(keyMaterials, clientKeyBytes, serverKeyBytes, cipherAlgorithm, keyBlock, offset, ivLength);
        }
        return keyMaterials;
    }

    private final byte[] generateKeyBlock(int protocolVersion, byte[] masterSecret, byte[] seed, byte[] serverRandom, byte[] clientRandom, int keyBlockLen, HashPRF hashPRF) throws DigestException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return TlsPrfGenerator.doTLS12PRF(masterSecret, LABEL_KEY_EXPANSION, seed, keyBlockLen, hashPRF);
    }

    private void setKeyMaterials(TlsKeyMaterials keyMaterials, byte[] clientKeyBytes, byte[] serverKeyBytes, String cipherAlgorithm, byte[] keyBlock, int offset, int ivLength) {
        keyMaterials.clientCipherKey = new SecretKeySpec(clientKeyBytes, cipherAlgorithm);
        keyMaterials.serverCipherKey = new SecretKeySpec(serverKeyBytes, cipherAlgorithm);
        if (ivLength != 0) {
            keyMaterials.clientIv = new IvParameterSpec(keyBlock, offset, ivLength);
            keyMaterials.serverIv = new IvParameterSpec(keyBlock, offset + ivLength, ivLength);
        }
    }

    private static SecretKey buildSecretKey(byte[] keyBlock, int offset, int macLength, String keyAlgorithm) {
        byte[] keyBytes = TlsKeyMaterialsTools.copyBytes(keyBlock, offset, macLength);
        return new SecretKeySpec(keyBytes, keyAlgorithm);
    }
}

