/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPremasterSecretParameters;
import cfca.sadk.tls.sun.security.ssl.sec.SecureRandoms;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class TlsPremasterSecretGenerator {
    static final TlsPremasterSecretGenerator INSTANCE = new TlsPremasterSecretGenerator();

    private TlsPremasterSecretGenerator() {
    }

    SecretKey generatePremasterKey(TlsPremasterSecretParameters params) {
        return this.generatePremasterKey(params, null);
    }

    SecretKey generatePremasterKey(TlsPremasterSecretParameters params, SecureRandom random) {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsPremasterSecretParameters"));
        }
        byte[] keyBytes = params.getEncodedSecret();
        if (keyBytes == null) {
            if (random == null) {
                random = SecureRandoms.newSecure();
            }
            keyBytes = new byte[48];
            random.nextBytes(keyBytes);
            keyBytes[0] = (byte)params.getMajorVersion();
            keyBytes[1] = (byte)params.getMinorVersion();
        }
        return new SecretKeySpec(keyBytes, "TlsPremasterSecret");
    }
}

