/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.util;

public class Args {
    private Args() {
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        return argument;
    }

    public static <T extends CharSequence> T notEmpty(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (Args.isEmpty(argument)) {
            throw new IllegalArgumentException(name + " may not be empty");
        }
        return argument;
    }

    public static <T extends CharSequence> T notBlank(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
        if (Args.isBlank(argument)) {
            throw new IllegalArgumentException(name + " may not be blank");
        }
        return argument;
    }

    public static boolean isEmpty(CharSequence s) {
        boolean isEmpty = true;
        if (s != null) {
            isEmpty = s.length() == 0;
        }
        return isEmpty;
    }

    public static boolean isBlank(CharSequence s) {
        boolean isBlank = true;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                isBlank = false;
                break;
            }
        }
        return isBlank;
    }

    public static boolean containsBlanks(CharSequence s) {
        boolean containsBlanks = false;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isWhitespace(s.charAt(i))) continue;
                containsBlanks = true;
                break;
            }
        }
        return containsBlanks;
    }
}

