/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.util;

import cfca.sadk.tls.kse.CertBean;
import cfca.sadk.tls.util.Loggings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;
import sun.security.action.GetPropertyAction;

public abstract class DeviceConf {
    private static final String TLS_CONFIG_FILENAME = "tls-device.cfg";
    private static final String TLS_CONFIG_EXTERNAL_FILEPATH = "config/tls-device.cfg";
    private static final boolean forTomcat;
    private static final String deviceType;
    private static final boolean checkIdentity;
    private static String cfgFilePath;
    private static final CertBean certBean;

    public static String getDevicetype() {
        return deviceType;
    }

    public static boolean isFortomcat() {
        return forTomcat;
    }

    public static boolean isCheckidentity() {
        return checkIdentity;
    }

    public static CertBean getCertbean() {
        return certBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadFromFile() {
        String jvmArgsFilePath = AccessController.doPrivileged(new GetPropertyAction("cfca.tls.device"));
        File file = jvmArgsFilePath == null || jvmArgsFilePath.isEmpty() ? new File(TLS_CONFIG_EXTERNAL_FILEPATH) : new File(jvmArgsFilePath);
        Loggings.ENVIRONMENT.info("tls-device.cfg: {}", (Object)file.getAbsolutePath());
        Properties properties = new Properties();
        InputStream in = null;
        try {
            if (file.isFile() && file.exists()) {
                in = new FileInputStream(file);
                cfgFilePath = file.getAbsolutePath();
                Loggings.ENVIRONMENT.info("tls-device.cfg load from externalFile: {}", (Object)cfgFilePath);
            } else {
                Loggings.ENVIRONMENT.warn("tls-device.cfg not found: {}", (Object)file.getAbsolutePath());
                Loggings.ERROR.error("tls-device.cfg not found: {}", (Object)file.getAbsolutePath());
                String filename = TLS_CONFIG_FILENAME;
                Loggings.ENVIRONMENT.info("tls-device.cfg trying load from internalJarFile: {}", (Object)TLS_CONFIG_FILENAME);
                ClassLoader classLoader = DeviceConf.class.getClassLoader();
                Loggings.ENVIRONMENT.info("classLoader: {}", (Object)classLoader);
                in = classLoader.getResourceAsStream(TLS_CONFIG_FILENAME);
                if (in != null) {
                    URL url = classLoader.getResource(TLS_CONFIG_FILENAME);
                    cfgFilePath = url != null ? file.getAbsolutePath() + " not exists, then use jar-->" + url.getPath() : file.getAbsolutePath() + " not exists, then use jar~";
                    Loggings.ENVIRONMENT.info("tls-device.cfg load from internalJarFile: {}", (Object)cfgFilePath);
                } else {
                    Loggings.ENVIRONMENT.warn("tls-device.cfg dot not load from internalJarFile");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            in = null;
        }
        if (in != null) {
            try {
                Loggings.ENVIRONMENT.info("tls-device.cfg load from start: {}", (Object)cfgFilePath);
                properties.load(in);
                Loggings.ENVIRONMENT.info("tls-device.cfg load from end: {}", (Object)cfgFilePath);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    static final StringBuilder appendME(StringBuilder builder) {
        builder.append("\n");
        builder.append("\n TLS\u517c\u5bb9\u914d\u7f6e: ");
        builder.append("\n###############################################");
        builder.append("\n  tls-device.cfg=");
        builder.append(cfgFilePath);
        builder.append("\n  deviceType=");
        builder.append(deviceType);
        builder.append("\n  checkIdentity=");
        builder.append(checkIdentity);
        builder.append(certBean);
        builder.append("\n###############################################");
        return builder;
    }

    static {
        String forTomcatFlag = AccessController.doPrivileged(new GetPropertyAction("cfca.tls.forTomcat"));
        Properties properties = DeviceConf.loadFromFile();
        deviceType = properties.getProperty("JCryptoDeviceType", "JSOFT_LIB");
        checkIdentity = "true".equalsIgnoreCase(properties.getProperty("checkIdentity", "true"));
        forTomcat = "true".equalsIgnoreCase(properties.getProperty("cfca.tls.forTomcat", forTomcatFlag));
        certBean = new CertBean(properties);
    }
}

