/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SM3Digest;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.crypto.params.KeyParameter;

public class SM3HMac {
    public static int BLOCK_LENGTH = 64;

    public static byte[] sm3_digest_bytes(byte[] msg) {
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg, 0, msg.length);
        sm3.doFinal(md, 0);
        return md;
    }

    public static byte[] SM3HashMacOld(byte[] text, byte[] key) {
        byte[] structured_key = new byte[BLOCK_LENGTH];
        byte[] IPAD = new byte[BLOCK_LENGTH];
        byte[] OPAD = new byte[BLOCK_LENGTH];
        if (key.length > BLOCK_LENGTH) {
            byte[] sm3_key = SM3HMac.sm3_digest_bytes(key);
            System.arraycopy(sm3_key, 0, structured_key, 0, sm3_key.length);
        } else {
            System.arraycopy(key, 0, structured_key, 0, key.length);
        }
        int i = 0;
        while (i < BLOCK_LENGTH) {
            IPAD[i] = 54;
            OPAD[i] = 92;
            ++i;
        }
        byte[] ipadkey = SM3HMac.XOR(structured_key, IPAD);
        int textLen = text.length;
        byte[] t3 = new byte[BLOCK_LENGTH + textLen];
        System.arraycopy(ipadkey, 0, t3, 0, ipadkey.length);
        System.arraycopy(text, 0, t3, ipadkey.length, text.length);
        byte[] t4 = SM3HMac.sm3_digest_bytes(t3);
        byte[] opadkey = SM3HMac.XOR(structured_key, OPAD);
        byte[] t6 = new byte[BLOCK_LENGTH + t4.length];
        System.arraycopy(opadkey, 0, t6, 0, opadkey.length);
        System.arraycopy(t4, 0, t6, opadkey.length, t4.length);
        return SM3HMac.sm3_digest_bytes(t6);
    }

    public static byte[] SM3HashMac(byte[] text, byte[] key) {
        byte[] res = new byte[32];
        HMac hmac = new HMac(new SM3Digest());
        hmac.init(new KeyParameter(key));
        hmac.update(text, 0, text.length);
        hmac.doFinal(res, 0);
        return res;
    }

    private static byte[] XOR(byte[] structured_key, byte[] iPAD) {
        byte[] ipadkey = new byte[structured_key.length];
        int i = 0;
        while (i < structured_key.length) {
            ipadkey[i] = (byte)(structured_key[i] ^ iPAD[i]);
            ++i;
        }
        return ipadkey;
    }

    public static void main(String[] args) {
        byte[] input = new byte[16];
        byte[] key = new byte[1024];
        key[0] = 97;
        key[1] = 98;
        key[2] = 99;
        key[3] = 100;
        key[4] = 101;
        key[5] = 102;
        System.out.print(Util.byteToHex(SM3HMac.SM3HashMac(input, key)));
    }
}

