/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1OutputStream;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Set;
import cn.win_trust_erpc.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;

public class DLSet
extends ASN1Set {
    private int contentsLength = -1;

    public DLSet() {
    }

    public DLSet(ASN1Encodable element) {
        super(element);
    }

    public DLSet(ASN1EncodableVector elementVector) {
        super(elementVector, false);
    }

    public DLSet(ASN1Encodable[] elements) {
        super(elements, false);
    }

    DLSet(boolean isSorted, ASN1Encodable[] elements) {
        super(isSorted, elements);
    }

    private int getContentsLength() throws IOException {
        if (this.contentsLength < 0) {
            int count = this.elements.length;
            int totalLength = 0;
            int i = 0;
            while (i < count) {
                ASN1Primitive dlObject = this.elements[i].toASN1Primitive().toDLObject();
                totalLength += dlObject.encodedLength(true);
                ++i;
            }
            this.contentsLength = totalLength;
        }
        return this.contentsLength;
    }

    @Override
    int encodedLength(boolean withTag) throws IOException {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.getContentsLength());
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeIdentifier(withTag, 49);
        DLOutputStream dlOut = out.getDLSubStream();
        int count = this.elements.length;
        if (this.contentsLength >= 0 || count > 16) {
            out.writeDL(this.getContentsLength());
            int i = 0;
            while (i < count) {
                ((ASN1OutputStream)dlOut).writePrimitive(this.elements[i].toASN1Primitive(), true);
                ++i;
            }
        } else {
            int totalLength = 0;
            ASN1Primitive[] dlObjects = new ASN1Primitive[count];
            int i = 0;
            while (i < count) {
                ASN1Primitive dlObject;
                dlObjects[i] = dlObject = this.elements[i].toASN1Primitive().toDLObject();
                totalLength += dlObject.encodedLength(true);
                ++i;
            }
            this.contentsLength = totalLength;
            out.writeDL(totalLength);
            i = 0;
            while (i < count) {
                ((ASN1OutputStream)dlOut).writePrimitive(dlObjects[i], true);
                ++i;
            }
        }
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }
}

