/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.tsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1TaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERTaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.cms.Attributes;
import cn.win_trust_erpc.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.cms.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.SignedData;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.tsp.PartialHashtree;
import cn.win_trust_erpc.bouncycastle.asn1.tsp.TSTInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class ArchiveTimeStamp
extends ASN1Object {
    private final AlgorithmIdentifier digestAlgorithm;
    private final Attributes attributes;
    private final ASN1Sequence reducedHashTree;
    private final ContentInfo timeStamp;

    public static ArchiveTimeStamp getInstance(Object obj) {
        if (obj instanceof ArchiveTimeStamp) {
            return (ArchiveTimeStamp)obj;
        }
        if (obj != null) {
            return new ArchiveTimeStamp(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ArchiveTimeStamp(AlgorithmIdentifier digestAlgorithm, PartialHashtree[] reducedHashTree, ContentInfo timeStamp) {
        this(digestAlgorithm, null, reducedHashTree, timeStamp);
    }

    public ArchiveTimeStamp(ContentInfo timeStamp) {
        this(null, null, null, timeStamp);
    }

    public ArchiveTimeStamp(AlgorithmIdentifier digestAlgorithm, Attributes attributes, PartialHashtree[] reducedHashTree, ContentInfo timeStamp) {
        this.digestAlgorithm = digestAlgorithm;
        this.attributes = attributes;
        this.reducedHashTree = reducedHashTree != null ? new DERSequence(reducedHashTree) : null;
        this.timeStamp = timeStamp;
    }

    private ArchiveTimeStamp(ASN1Sequence sequence) {
        if (sequence.size() < 1 || sequence.size() > 4) {
            throw new IllegalArgumentException("wrong sequence size in constructor: " + sequence.size());
        }
        AlgorithmIdentifier digAlg = null;
        Attributes attrs = null;
        ASN1Sequence rHashTree = null;
        int i = 0;
        while (i < sequence.size() - 1) {
            ASN1Encodable obj = sequence.getObjectAt(i);
            if (obj instanceof ASN1TaggedObject) {
                ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(obj);
                switch (taggedObject.getTagNo()) {
                    case 0: {
                        digAlg = AlgorithmIdentifier.getInstance(taggedObject, false);
                        break;
                    }
                    case 1: {
                        attrs = Attributes.getInstance(taggedObject, false);
                        break;
                    }
                    case 2: {
                        rHashTree = ASN1Sequence.getInstance(taggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid tag no in constructor: " + taggedObject.getTagNo());
                    }
                }
            }
            ++i;
        }
        this.digestAlgorithm = digAlg;
        this.attributes = attrs;
        this.reducedHashTree = rHashTree;
        this.timeStamp = ContentInfo.getInstance(sequence.getObjectAt(sequence.size() - 1));
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        if (this.digestAlgorithm != null) {
            return this.digestAlgorithm;
        }
        if (this.timeStamp.getContentType().equals(CMSObjectIdentifiers.signedData)) {
            SignedData tsData = SignedData.getInstance(this.timeStamp.getContent());
            if (tsData.getEncapContentInfo().getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
                TSTInfo tstData = TSTInfo.getInstance(tsData.getEncapContentInfo());
                return tstData.getMessageImprint().getHashAlgorithm();
            }
            throw new IllegalStateException("cannot parse time stamp");
        }
        throw new IllegalStateException("cannot identify algorithm identifier for digest");
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public PartialHashtree[] getReducedHashTree() {
        if (this.reducedHashTree == null) {
            return null;
        }
        PartialHashtree[] rv = new PartialHashtree[this.reducedHashTree.size()];
        int i = 0;
        while (i != rv.length) {
            rv[i] = PartialHashtree.getInstance(this.reducedHashTree.getObjectAt(i));
            ++i;
        }
        return rv;
    }

    public ContentInfo getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(4);
        if (this.digestAlgorithm != null) {
            v.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.digestAlgorithm));
        }
        if (this.attributes != null) {
            v.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.attributes));
        }
        if (this.reducedHashTree != null) {
            v.add(new DERTaggedObject(false, 2, (ASN1Encodable)this.reducedHashTree));
        }
        v.add(this.timeStamp);
        return new DERSequence(v);
    }
}

