/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms;

import cn.win_trust_erpc.bouncycastle.asn1.BEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.BERSet;
import cn.win_trust_erpc.bouncycastle.asn1.cms.AttributeTable;
import cn.win_trust_erpc.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.cms.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.EncryptedContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.EncryptedData;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.cms.CMSEncryptedData;
import cn.win_trust_erpc.bouncycastle.cms.CMSEncryptedGenerator;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSTypedData;
import cn.win_trust_erpc.bouncycastle.operator.OutputEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;

public class CMSEncryptedDataGenerator
extends CMSEncryptedGenerator {
    private CMSEncryptedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        EncryptedContentInfo eci = new EncryptedContentInfo(content.getContentType(), encAlgId, encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(Collections.EMPTY_MAP);
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.encryptedData, new EncryptedData(eci, unprotectedAttrSet));
        return new CMSEncryptedData(contentInfo);
    }

    public CMSEncryptedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

