/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Set;
import cn.win_trust_erpc.bouncycastle.asn1.cms.KEKRecipientInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.PasswordRecipientInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.RecipientInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.cms.AuthAttributesProvider;
import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSReadable;
import cn.win_trust_erpc.bouncycastle.cms.CMSSecureReadable;
import cn.win_trust_erpc.bouncycastle.cms.KEKRecipientInformation;
import cn.win_trust_erpc.bouncycastle.cms.KeyAgreeRecipientInformation;
import cn.win_trust_erpc.bouncycastle.cms.KeyTransRecipientInformation;
import cn.win_trust_erpc.bouncycastle.cms.PasswordRecipientInformation;
import cn.win_trust_erpc.bouncycastle.cms.RecipientInformation;
import cn.win_trust_erpc.bouncycastle.cms.RecipientInformationStore;
import cn.win_trust_erpc.bouncycastle.operator.DigestCalculator;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class CMSEnvelopedHelper {
    CMSEnvelopedHelper() {
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable) {
        return CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, messageAlgorithm, secureReadable, null);
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ArrayList<RecipientInformation> infos = new ArrayList<RecipientInformation>();
        int i = 0;
        while (i != recipientInfos.size()) {
            RecipientInfo info = RecipientInfo.getInstance(recipientInfos.getObjectAt(i));
            CMSEnvelopedHelper.readRecipientInfo(infos, info, messageAlgorithm, secureReadable, additionalData);
            ++i;
        }
        return new RecipientInformationStore(infos);
    }

    private static void readRecipientInfo(List infos, RecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ASN1Encodable recipInfo = info.getInfo();
        if (recipInfo instanceof KeyTransRecipientInfo) {
            infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        } else if (recipInfo instanceof KEKRecipientInfo) {
            infos.add(new KEKRecipientInformation((KEKRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        } else if (recipInfo instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(infos, (KeyAgreeRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData);
        } else if (recipInfo instanceof PasswordRecipientInfo) {
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        }
    }

    static class CMSAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private final ASN1ObjectIdentifier contentType;
        private CMSReadable readable;

        CMSAuthenticatedSecureReadable(AlgorithmIdentifier algorithm, ASN1ObjectIdentifier contentType, CMSReadable readable) {
            this.algorithm = algorithm;
            this.contentType = contentType;
            this.readable = readable;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private DigestCalculator digestCalculator;
        private final ASN1ObjectIdentifier contentType;
        private CMSReadable readable;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, ASN1ObjectIdentifier contentType, CMSReadable readable) {
            this.digestCalculator = digestCalculator;
            this.contentType = contentType;
            this.readable = readable;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this.readable.getInputStream()){

                @Override
                public int read() throws IOException {
                    int b = this.in.read();
                    if (b >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(b);
                    }
                    return b;
                }

                @Override
                public int read(byte[] inBuf, int inOff, int inLen) throws IOException {
                    int n = this.in.read(inBuf, inOff, inLen);
                    if (n >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(inBuf, inOff, n);
                    }
                    return n;
                }
            };
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }
    }

    static class CMSEnvelopedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private final ASN1ObjectIdentifier contentType;
        private CMSReadable readable;

        CMSEnvelopedSecureReadable(AlgorithmIdentifier algorithm, ASN1ObjectIdentifier contentType, CMSReadable readable) {
            this.algorithm = algorithm;
            this.contentType = contentType;
            this.readable = readable;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.contentType;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }
}

