/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms.bc;

import cn.win_trust_erpc.bouncycastle.cert.X509CertificateHolder;
import cn.win_trust_erpc.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import cn.win_trust_erpc.bouncycastle.cms.SignerInformationVerifier;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cn.win_trust_erpc.bouncycastle.operator.DigestCalculatorProvider;
import cn.win_trust_erpc.bouncycastle.operator.OperatorCreationException;
import cn.win_trust_erpc.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcEdDSAContentVerifierProviderBuilder;

public class BcEdDSASignerInfoVerifierBuilder {
    private BcEdDSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcEdDSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator sigAlgNameGen, SignatureAlgorithmIdentifierFinder sigAlgIdFinder, DigestAlgorithmIdentifierFinder digestAlgorithmFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = sigAlgNameGen;
        this.sigAlgIdFinder = sigAlgIdFinder;
        this.contentVerifierProviderBuilder = new BcEdDSAContentVerifierProviderBuilder();
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder certHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(certHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter pubKey) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(pubKey), this.digestCalculatorProvider);
    }
}

