/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.digests;

import cn.win_trust_erpc.bouncycastle.crypto.Digest;

public abstract class HarakaBase
implements Digest {
    protected static final int DIGEST_SIZE = 32;
    private static final byte[][] S;

    static {
        byte[][] byArrayArray = new byte[16][];
        byArrayArray[0] = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118};
        byArrayArray[1] = new byte[]{-54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64};
        byArrayArray[2] = new byte[]{-73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21};
        byArrayArray[3] = new byte[]{4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117};
        byArrayArray[4] = new byte[]{9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124};
        byte[] byArray = new byte[16];
        byArray[0] = 83;
        byArray[1] = -47;
        byArray[3] = -19;
        byArray[4] = 32;
        byArray[5] = -4;
        byArray[6] = -79;
        byArray[7] = 91;
        byArray[8] = 106;
        byArray[9] = -53;
        byArray[10] = -66;
        byArray[11] = 57;
        byArray[12] = 74;
        byArray[13] = 76;
        byArray[14] = 88;
        byArray[15] = -49;
        byArrayArray[5] = byArray;
        byArrayArray[6] = new byte[]{-48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88};
        byArrayArray[7] = new byte[]{81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46};
        byArrayArray[8] = new byte[]{-51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115};
        byArrayArray[9] = new byte[]{96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37};
        byArrayArray[10] = new byte[]{-32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121};
        byArrayArray[11] = new byte[]{-25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8};
        byArrayArray[12] = new byte[]{-70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118};
        byArrayArray[13] = new byte[]{112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98};
        byArrayArray[14] = new byte[]{-31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33};
        byArrayArray[15] = new byte[]{-116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
        S = byArrayArray;
    }

    static byte sBox(byte x) {
        return S[(x & 0xFF) >>> 4][x & 0xF];
    }

    static byte[] subBytes(byte[] s) {
        byte[] out = new byte[s.length];
        out[0] = HarakaBase.sBox(s[0]);
        out[1] = HarakaBase.sBox(s[1]);
        out[2] = HarakaBase.sBox(s[2]);
        out[3] = HarakaBase.sBox(s[3]);
        out[4] = HarakaBase.sBox(s[4]);
        out[5] = HarakaBase.sBox(s[5]);
        out[6] = HarakaBase.sBox(s[6]);
        out[7] = HarakaBase.sBox(s[7]);
        out[8] = HarakaBase.sBox(s[8]);
        out[9] = HarakaBase.sBox(s[9]);
        out[10] = HarakaBase.sBox(s[10]);
        out[11] = HarakaBase.sBox(s[11]);
        out[12] = HarakaBase.sBox(s[12]);
        out[13] = HarakaBase.sBox(s[13]);
        out[14] = HarakaBase.sBox(s[14]);
        out[15] = HarakaBase.sBox(s[15]);
        return out;
    }

    static byte[] shiftRows(byte[] s) {
        return new byte[]{s[0], s[5], s[10], s[15], s[4], s[9], s[14], s[3], s[8], s[13], s[2], s[7], s[12], s[1], s[6], s[11]};
    }

    static byte[] aesEnc(byte[] s, byte[] rk) {
        s = HarakaBase.subBytes(s);
        s = HarakaBase.shiftRows(s);
        s = HarakaBase.mixColumns(s);
        HarakaBase.xorReverse(s, rk);
        return s;
    }

    static byte xTime(byte x) {
        if (x >>> 7 > 0) {
            return (byte)((x << 1 ^ 0x1B) & 0xFF);
        }
        return (byte)(x << 1 & 0xFF);
    }

    static void xorReverse(byte[] x, byte[] y) {
        x[0] = (byte)(x[0] ^ y[15]);
        x[1] = (byte)(x[1] ^ y[14]);
        x[2] = (byte)(x[2] ^ y[13]);
        x[3] = (byte)(x[3] ^ y[12]);
        x[4] = (byte)(x[4] ^ y[11]);
        x[5] = (byte)(x[5] ^ y[10]);
        x[6] = (byte)(x[6] ^ y[9]);
        x[7] = (byte)(x[7] ^ y[8]);
        x[8] = (byte)(x[8] ^ y[7]);
        x[9] = (byte)(x[9] ^ y[6]);
        x[10] = (byte)(x[10] ^ y[5]);
        x[11] = (byte)(x[11] ^ y[4]);
        x[12] = (byte)(x[12] ^ y[3]);
        x[13] = (byte)(x[13] ^ y[2]);
        x[14] = (byte)(x[14] ^ y[1]);
        x[15] = (byte)(x[15] ^ y[0]);
    }

    static byte[] xor(byte[] x, byte[] y, int yStart) {
        byte[] out = new byte[16];
        int i = 0;
        while (i < out.length) {
            out[i] = (byte)(x[i] ^ y[yStart++]);
            ++i;
        }
        return out;
    }

    private static byte[] mixColumns(byte[] s) {
        byte[] out = new byte[s.length];
        int j = 0;
        int i = 0;
        while (i < 4) {
            out[j++] = (byte)(HarakaBase.xTime(s[4 * i]) ^ HarakaBase.xTime(s[4 * i + 1]) ^ s[4 * i + 1] ^ s[4 * i + 2] ^ s[4 * i + 3]);
            out[j++] = (byte)(s[4 * i] ^ HarakaBase.xTime(s[4 * i + 1]) ^ HarakaBase.xTime(s[4 * i + 2]) ^ s[4 * i + 2] ^ s[4 * i + 3]);
            out[j++] = (byte)(s[4 * i] ^ s[4 * i + 1] ^ HarakaBase.xTime(s[4 * i + 2]) ^ HarakaBase.xTime(s[4 * i + 3]) ^ s[4 * i + 3]);
            out[j++] = (byte)(HarakaBase.xTime(s[4 * i]) ^ s[4 * i] ^ s[4 * i + 1] ^ s[4 * i + 2] ^ HarakaBase.xTime(s[4 * i + 3]));
            ++i;
        }
        return out;
    }

    @Override
    public int getDigestSize() {
        return 32;
    }
}

