/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.modes.gcm;

import cn.win_trust_erpc.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import cn.win_trust_erpc.bouncycastle.crypto.modes.gcm.GCMUtil;
import java.util.Vector;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] x) {
        long[] y = GCMUtil.asLongs(x);
        if (this.lookupPowX2 != null && 0L != GCMUtil.areEqual(y, (long[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(y);
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        long[] y = GCMUtil.oneAsLongs();
        int bit = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                this.ensureAvailable(bit);
                GCMUtil.multiply(y, (long[])this.lookupPowX2.elementAt(bit));
            }
            ++bit;
            pow >>>= 1;
        }
        GCMUtil.asBytes(y, output);
    }

    private void ensureAvailable(int bit) {
        int last = this.lookupPowX2.size() - 1;
        if (last < bit) {
            long[] prev = (long[])this.lookupPowX2.elementAt(last);
            do {
                long[] next = new long[2];
                GCMUtil.square(prev, next);
                this.lookupPowX2.addElement(next);
                prev = next;
            } while (++last < bit);
        }
    }
}

