/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.modes.gcm;

import cn.win_trust_erpc.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import cn.win_trust_erpc.bouncycastle.crypto.modes.gcm.GCMUtil;
import cn.win_trust_erpc.bouncycastle.util.Pack;

public class Tables4kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][] T;

    @Override
    public void init(byte[] H) {
        if (this.T == null) {
            this.T = new long[256][2];
        } else if (GCMUtil.areEqual(this.H, H) != 0) {
            return;
        }
        this.H = new byte[16];
        GCMUtil.copy(H, this.H);
        GCMUtil.asLongs(this.H, this.T[1]);
        GCMUtil.multiplyP7(this.T[1], this.T[1]);
        int n = 2;
        while (n < 256) {
            GCMUtil.divideP(this.T[n >> 1], this.T[n]);
            GCMUtil.xor(this.T[n], this.T[1], this.T[n + 1]);
            n += 2;
        }
    }

    @Override
    public void multiplyH(byte[] x) {
        long[] t = this.T[x[15] & 0xFF];
        long z0 = t[0];
        long z1 = t[1];
        int i = 14;
        while (i >= 0) {
            t = this.T[x[i] & 0xFF];
            long c = z1 << 56;
            z1 = t[1] ^ (z1 >>> 8 | z0 << 56);
            z0 = t[0] ^ z0 >>> 8 ^ c ^ c >>> 1 ^ c >>> 2 ^ c >>> 7;
            --i;
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }
}

