/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.gost;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.gost.BCGOST3410PrivateKey;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.gost.BCGOST3410PublicKey;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import cn.win_trust_erpc.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import cn.win_trust_erpc.bouncycastle.jce.interfaces.GOST3410PublicKey;
import cn.win_trust_erpc.bouncycastle.jce.spec.GOST3410PrivateKeySpec;
import cn.win_trust_erpc.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import cn.win_trust_erpc.bouncycastle.jce.spec.GOST3410PublicKeySpec;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    @Override
    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(GOST3410PublicKeySpec.class) && key instanceof GOST3410PublicKey) {
            GOST3410PublicKey k = (GOST3410PublicKey)key;
            GOST3410PublicKeyParameterSetSpec parameters = k.getParameters().getPublicKeyParameters();
            return new GOST3410PublicKeySpec(k.getY(), parameters.getP(), parameters.getQ(), parameters.getA());
        }
        if (spec.isAssignableFrom(GOST3410PrivateKeySpec.class) && key instanceof GOST3410PrivateKey) {
            GOST3410PrivateKey k = (GOST3410PrivateKey)key;
            GOST3410PublicKeyParameterSetSpec parameters = k.getParameters().getPublicKeyParameters();
            return new GOST3410PrivateKeySpec(k.getX(), parameters.getP(), parameters.getQ(), parameters.getA());
        }
        return super.engineGetKeySpec(key, spec);
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof GOST3410PublicKey) {
            return new BCGOST3410PublicKey((GOST3410PublicKey)key);
        }
        if (key instanceof GOST3410PrivateKey) {
            return new BCGOST3410PrivateKey((GOST3410PrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof GOST3410PrivateKeySpec) {
            return new BCGOST3410PrivateKey((GOST3410PrivateKeySpec)keySpec);
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof GOST3410PublicKeySpec) {
            return new BCGOST3410PublicKey((GOST3410PublicKeySpec)keySpec);
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new BCGOST3410PrivateKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1ObjectIdentifier algOid = keyInfo.getAlgorithm().getAlgorithm();
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new BCGOST3410PublicKey(keyInfo);
        }
        throw new IOException("algorithm identifier " + algOid + " in key not recognised");
    }
}

