/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.digest;

import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.digests.KeccakDigest;
import cn.win_trust_erpc.bouncycastle.crypto.macs.HMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Keccak {
    private Keccak() {
    }

    public static class Digest224
    extends DigestKeccak {
        public Digest224() {
            super(224);
        }
    }

    public static class Digest256
    extends DigestKeccak {
        public Digest256() {
            super(256);
        }
    }

    public static class Digest288
    extends DigestKeccak {
        public Digest288() {
            super(288);
        }
    }

    public static class Digest384
    extends DigestKeccak {
        public Digest384() {
            super(384);
        }
    }

    public static class Digest512
    extends DigestKeccak {
        public Digest512() {
            super(512);
        }
    }

    public static class DigestKeccak
    extends BCMessageDigest
    implements Cloneable {
        public DigestKeccak(int size) {
            super(new KeccakDigest(size));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest d = (BCMessageDigest)super.clone();
            d.digest = new KeccakDigest((KeccakDigest)this.digest);
            return d;
        }
    }

    public static class HashMac224
    extends BaseMac {
        public HashMac224() {
            super(new HMac(new KeccakDigest(224)));
        }
    }

    public static class HashMac256
    extends BaseMac {
        public HashMac256() {
            super(new HMac(new KeccakDigest(256)));
        }
    }

    public static class HashMac288
    extends BaseMac {
        public HashMac288() {
            super(new HMac(new KeccakDigest(288)));
        }
    }

    public static class HashMac384
    extends BaseMac {
        public HashMac384() {
            super(new HMac(new KeccakDigest(384)));
        }
    }

    public static class HashMac512
    extends BaseMac {
        public HashMac512() {
            super(new HMac(new KeccakDigest(512)));
        }
    }

    public static class KeyGenerator224
    extends BaseKeyGenerator {
        public KeyGenerator224() {
            super("HMACKECCAK224", 224, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator256
    extends BaseKeyGenerator {
        public KeyGenerator256() {
            super("HMACKECCAK256", 256, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator288
    extends BaseKeyGenerator {
        public KeyGenerator288() {
            super("HMACKECCAK288", 288, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator384
    extends BaseKeyGenerator {
        public KeyGenerator384() {
            super("HMACKECCAK384", 384, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator512
    extends BaseKeyGenerator {
        public KeyGenerator512() {
            super("HMACKECCAK512", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Keccak.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.KECCAK-224", String.valueOf(PREFIX) + "$Digest224");
            provider.addAlgorithm("MessageDigest.KECCAK-288", String.valueOf(PREFIX) + "$Digest288");
            provider.addAlgorithm("MessageDigest.KECCAK-256", String.valueOf(PREFIX) + "$Digest256");
            provider.addAlgorithm("MessageDigest.KECCAK-384", String.valueOf(PREFIX) + "$Digest384");
            provider.addAlgorithm("MessageDigest.KECCAK-512", String.valueOf(PREFIX) + "$Digest512");
            this.addHMACAlgorithm(provider, "KECCAK224", String.valueOf(PREFIX) + "$HashMac224", String.valueOf(PREFIX) + "$KeyGenerator224");
            this.addHMACAlgorithm(provider, "KECCAK256", String.valueOf(PREFIX) + "$HashMac256", String.valueOf(PREFIX) + "$KeyGenerator256");
            this.addHMACAlgorithm(provider, "KECCAK288", String.valueOf(PREFIX) + "$HashMac288", String.valueOf(PREFIX) + "$KeyGenerator288");
            this.addHMACAlgorithm(provider, "KECCAK384", String.valueOf(PREFIX) + "$HashMac384", String.valueOf(PREFIX) + "$KeyGenerator384");
            this.addHMACAlgorithm(provider, "KECCAK512", String.valueOf(PREFIX) + "$HashMac512", String.valueOf(PREFIX) + "$KeyGenerator512");
        }
    }
}

