/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCX509ExtendedKeyManager;
import cn.win_trust_erpc.bouncycastle.jsse.BCX509ExtendedTrustManager;
import cn.win_trust_erpc.bouncycastle.jsse.provider.NamedGroupInfo;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLContextSpi;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLSessionContext;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SignatureSchemeInfo;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import java.util.List;
import java.util.Vector;

final class ContextData {
    private final ProvSSLContextSpi context;
    private final TlsCrypto crypto;
    private final BCX509ExtendedKeyManager x509KeyManager;
    private final BCX509ExtendedTrustManager x509TrustManager;
    private final ProvSSLSessionContext clientSessionContext;
    private final ProvSSLSessionContext serverSessionContext;
    private final NamedGroupInfo.PerContext namedGroups;
    private final SignatureSchemeInfo.PerContext signatureSchemes;

    ContextData(ProvSSLContextSpi context, TlsCrypto crypto, BCX509ExtendedKeyManager x509KeyManager, BCX509ExtendedTrustManager x509TrustManager) {
        this.context = context;
        this.crypto = crypto;
        this.x509KeyManager = x509KeyManager;
        this.x509TrustManager = x509TrustManager;
        this.clientSessionContext = new ProvSSLSessionContext(this);
        this.serverSessionContext = new ProvSSLSessionContext(this);
        this.namedGroups = NamedGroupInfo.createPerContext(context.isFips(), crypto);
        this.signatureSchemes = SignatureSchemeInfo.createPerContext(context.isFips(), crypto, this.namedGroups);
    }

    NamedGroupInfo.PerConnection getNamedGroups(ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        return NamedGroupInfo.createPerConnection(this.namedGroups, sslParameters, activeProtocolVersions);
    }

    List<SignatureSchemeInfo> getActiveCertsSignatureSchemes(boolean isServer, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions, NamedGroupInfo.PerConnection namedGroups) {
        return SignatureSchemeInfo.getActiveCertsSignatureSchemes(this.signatureSchemes, isServer, sslParameters, activeProtocolVersions, namedGroups);
    }

    ProvSSLContextSpi getContext() {
        return this.context;
    }

    TlsCrypto getCrypto() {
        return this.crypto;
    }

    ProvSSLSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    ProvSSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    List<SignatureSchemeInfo> getSignatureSchemes(Vector<SignatureAndHashAlgorithm> sigAndHashAlgs) {
        return SignatureSchemeInfo.getSignatureSchemes(this.signatureSchemes, sigAndHashAlgs);
    }

    BCX509ExtendedKeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    BCX509ExtendedTrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }
}

