/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.BCExtendedSSLSession;
import cn.win_trust_erpc.bouncycastle.jsse.BCSSLParameters;
import cn.win_trust_erpc.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.JsseUtils;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLEngineUtil;
import cn.win_trust_erpc.bouncycastle.jsse.provider.SSLSocketUtil;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;

class TransportData {
    private final BCSSLParameters parameters;
    private final BCExtendedSSLSession handshakeSession;

    static TransportData from(Socket socket) {
        if (!(socket instanceof SSLSocket) || !socket.isConnected()) {
            return null;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        BCSSLParameters parameters = SSLSocketUtil.importSSLParameters(sslSocket);
        if (parameters == null) {
            return null;
        }
        BCExtendedSSLSession handshakeSession = SSLSocketUtil.importHandshakeSession(sslSocket);
        return new TransportData(parameters, handshakeSession);
    }

    static TransportData from(SSLEngine engine) {
        if (engine == null) {
            return null;
        }
        BCSSLParameters parameters = SSLEngineUtil.importSSLParameters(engine);
        if (parameters == null) {
            return null;
        }
        BCExtendedSSLSession handshakeSession = SSLEngineUtil.importHandshakeSession(engine);
        return new TransportData(parameters, handshakeSession);
    }

    static BCAlgorithmConstraints getAlgorithmConstraints(TransportData transportData, boolean peerSigAlgs) {
        return transportData == null ? ProvAlgorithmConstraints.DEFAULT : transportData.getAlgorithmConstraints(peerSigAlgs);
    }

    static List<byte[]> getStatusResponses(TransportData transportData) {
        return transportData == null ? Collections.emptyList() : transportData.getStatusResponses();
    }

    private TransportData(BCSSLParameters parameters, BCExtendedSSLSession handshakeSession) {
        this.parameters = parameters;
        this.handshakeSession = handshakeSession;
    }

    BCSSLParameters getParameters() {
        return this.parameters;
    }

    BCExtendedSSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    BCAlgorithmConstraints getAlgorithmConstraints(boolean peerSigAlgs) {
        BCAlgorithmConstraints configAlgorithmConstraints = this.parameters.getAlgorithmConstraints();
        if (ProvAlgorithmConstraints.DEFAULT == configAlgorithmConstraints) {
            configAlgorithmConstraints = null;
        }
        if (this.handshakeSession != null && JsseUtils.isTLSv12(this.handshakeSession.getProtocol())) {
            String[] sigAlgsCert;
            String[] stringArray = sigAlgsCert = peerSigAlgs ? this.handshakeSession.getPeerSupportedSignatureAlgorithmsBC() : this.handshakeSession.getLocalSupportedSignatureAlgorithmsBC();
            if (sigAlgsCert != null) {
                return new ProvAlgorithmConstraints(configAlgorithmConstraints, sigAlgsCert, true);
            }
        }
        return configAlgorithmConstraints == null ? ProvAlgorithmConstraints.DEFAULT : new ProvAlgorithmConstraints(configAlgorithmConstraints, true);
    }

    List<byte[]> getStatusResponses() {
        return this.handshakeSession == null ? Collections.emptyList() : this.handshakeSession.getStatusResponses();
    }
}

