/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.math.ec.custom.sec;

import cn.win_trust_erpc.bouncycastle.math.ec.AbstractECLookupTable;
import cn.win_trust_erpc.bouncycastle.math.ec.ECConstants;
import cn.win_trust_erpc.bouncycastle.math.ec.ECCurve;
import cn.win_trust_erpc.bouncycastle.math.ec.ECFieldElement;
import cn.win_trust_erpc.bouncycastle.math.ec.ECLookupTable;
import cn.win_trust_erpc.bouncycastle.math.ec.ECPoint;
import cn.win_trust_erpc.bouncycastle.math.ec.custom.sec.SecT163FieldElement;
import cn.win_trust_erpc.bouncycastle.math.ec.custom.sec.SecT163R1Point;
import cn.win_trust_erpc.bouncycastle.math.raw.Nat192;
import cn.win_trust_erpc.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT163R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT163R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT163R1_AFFINE_ZS = new ECFieldElement[]{new SecT163FieldElement(ECConstants.ONE)};
    protected SecT163R1Point infinity = new SecT163R1Point(this, null, null);

    public SecT163R1Curve() {
        super(163, 3, 6, 7);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("07B6882CAAEFA84F9554FF8428BD88E246D2782AE2")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0713612DCDDCB40AAB946BDA29CA91F73AF958AFD9")));
        this.order = new BigInteger(1, Hex.decodeStrict("03FFFFFFFFFFFFFFFFFFFF48AAB689C29CA710279B"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT163R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 163;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT163FieldElement(x);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y) {
        return new SecT163R1Point(this, x, y);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs) {
        return new SecT163R1Point(this, x, y, zs);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 163;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 3;
    }

    public int getK2() {
        return 6;
    }

    public int getK3() {
        return 7;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 3;
        final long[] table = new long[len * 3 * 2];
        int pos = 0;
        int i = 0;
        while (i < len) {
            ECPoint p = points[off + i];
            Nat192.copy64(((SecT163FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat192.copy64(((SecT163FieldElement)p.getRawYCoord()).x, 0, table, pos += 3);
            pos += 3;
            ++i;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return len;
            }

            @Override
            public ECPoint lookup(int index) {
                long[] x = Nat192.create64();
                long[] y = Nat192.create64();
                int pos = 0;
                int i = 0;
                while (i < len) {
                    long MASK = (i ^ index) - 1 >> 31;
                    int j = 0;
                    while (j < 3) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 3 + j] & MASK;
                        ++j;
                    }
                    pos += 6;
                    ++i;
                }
                return this.createPoint(x, y);
            }

            @Override
            public ECPoint lookupVar(int index) {
                long[] x = Nat192.create64();
                long[] y = Nat192.create64();
                int pos = index * 3 * 2;
                int j = 0;
                while (j < 3) {
                    x[j] = table[pos + j];
                    y[j] = table[pos + 3 + j];
                    ++j;
                }
                return this.createPoint(x, y);
            }

            private ECPoint createPoint(long[] x, long[] y) {
                return SecT163R1Curve.this.createRawPoint(new SecT163FieldElement(x), new SecT163FieldElement(y), SECT163R1_AFFINE_ZS);
            }
        };
    }
}

