/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.operator;

import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.operator.ContentSigner;
import cn.win_trust_erpc.bouncycastle.util.io.BufferingOutputStream;
import java.io.OutputStream;

public class BufferingContentSigner
implements ContentSigner {
    private final ContentSigner contentSigner;
    private final OutputStream output;

    public BufferingContentSigner(ContentSigner contentSigner) {
        this.contentSigner = contentSigner;
        this.output = new BufferingOutputStream(contentSigner.getOutputStream());
    }

    public BufferingContentSigner(ContentSigner contentSigner, int bufferSize) {
        this.contentSigner = contentSigner;
        this.output = new BufferingOutputStream(contentSigner.getOutputStream(), bufferSize);
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.contentSigner.getAlgorithmIdentifier();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public byte[] getSignature() {
        return this.contentSigner.getSignature();
    }
}

