/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.MessageSigner;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil gmssUtil = new GMSSUtil();
    private byte[] pubKeyBytes;
    private Digest messDigestTrees;
    private int mdLength;
    private int numLayer;
    private Digest messDigestOTS;
    private WinternitzOTSignature ots;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private byte[][][] currentAuthPaths;
    private byte[][] subtreeRootSig;
    private GMSSParameters gmssPS;
    private GMSSRandom gmssRandom;
    GMSSKeyParameters key;
    private SecureRandom random;

    public GMSSSigner(GMSSDigestProvider digest) {
        this.digestProvider = digest;
        this.messDigestOTS = this.messDigestTrees = digest.get();
        this.mdLength = this.messDigestTrees.getDigestSize();
        this.gmssRandom = new GMSSRandom(this.messDigestTrees);
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (GMSSPrivateKeyParameters)rParam.getParameters();
                this.initSign();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (GMSSPrivateKeyParameters)param;
                this.initSign();
            }
        } else {
            this.key = (GMSSPublicKeyParameters)param;
            this.initVerify();
        }
    }

    private void initSign() {
        int i;
        this.messDigestTrees.reset();
        GMSSPrivateKeyParameters gmssPrivateKey = (GMSSPrivateKeyParameters)this.key;
        if (gmssPrivateKey.isUsed()) {
            throw new IllegalStateException("Private key already used");
        }
        if (gmssPrivateKey.getIndex(0) >= gmssPrivateKey.getNumLeafs(0)) {
            throw new IllegalStateException("No more signatures can be generated");
        }
        this.gmssPS = gmssPrivateKey.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
        byte[] seed = gmssPrivateKey.getCurrentSeeds()[this.numLayer - 1];
        byte[] OTSSeed = new byte[this.mdLength];
        byte[] dummy = new byte[this.mdLength];
        System.arraycopy(seed, 0, dummy, 0, this.mdLength);
        OTSSeed = this.gmssRandom.nextSeed(dummy);
        this.ots = new WinternitzOTSignature(OTSSeed, this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[this.numLayer - 1]);
        byte[][][] helpCurrentAuthPaths = gmssPrivateKey.getCurrentAuthPaths();
        this.currentAuthPaths = new byte[this.numLayer][][];
        int j = 0;
        while (j < this.numLayer) {
            this.currentAuthPaths[j] = new byte[helpCurrentAuthPaths[j].length][this.mdLength];
            i = 0;
            while (i < helpCurrentAuthPaths[j].length) {
                System.arraycopy(helpCurrentAuthPaths[j][i], 0, this.currentAuthPaths[j][i], 0, this.mdLength);
                ++i;
            }
            ++j;
        }
        this.index = new int[this.numLayer];
        System.arraycopy(gmssPrivateKey.getIndex(), 0, this.index, 0, this.numLayer);
        this.subtreeRootSig = new byte[this.numLayer - 1][];
        i = 0;
        while (i < this.numLayer - 1) {
            byte[] helpSubtreeRootSig = gmssPrivateKey.getSubtreeRootSig(i);
            this.subtreeRootSig[i] = new byte[helpSubtreeRootSig.length];
            System.arraycopy(helpSubtreeRootSig, 0, this.subtreeRootSig[i], 0, helpSubtreeRootSig.length);
            ++i;
        }
        gmssPrivateKey.markUsed();
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        byte[] otsSig = new byte[this.mdLength];
        otsSig = this.ots.getSignature(message);
        byte[] authPathBytes = this.gmssUtil.concatenateArray(this.currentAuthPaths[this.numLayer - 1]);
        byte[] indexBytes = this.gmssUtil.intToBytesLittleEndian(this.index[this.numLayer - 1]);
        byte[] gmssSigFirstPart = new byte[indexBytes.length + otsSig.length + authPathBytes.length];
        System.arraycopy(indexBytes, 0, gmssSigFirstPart, 0, indexBytes.length);
        System.arraycopy(otsSig, 0, gmssSigFirstPart, indexBytes.length, otsSig.length);
        System.arraycopy(authPathBytes, 0, gmssSigFirstPart, indexBytes.length + otsSig.length, authPathBytes.length);
        byte[] gmssSigNextPart = new byte[]{};
        int i = this.numLayer - 1 - 1;
        while (i >= 0) {
            authPathBytes = this.gmssUtil.concatenateArray(this.currentAuthPaths[i]);
            indexBytes = this.gmssUtil.intToBytesLittleEndian(this.index[i]);
            byte[] helpGmssSig = new byte[gmssSigNextPart.length];
            System.arraycopy(gmssSigNextPart, 0, helpGmssSig, 0, gmssSigNextPart.length);
            gmssSigNextPart = new byte[helpGmssSig.length + indexBytes.length + this.subtreeRootSig[i].length + authPathBytes.length];
            System.arraycopy(helpGmssSig, 0, gmssSigNextPart, 0, helpGmssSig.length);
            System.arraycopy(indexBytes, 0, gmssSigNextPart, helpGmssSig.length, indexBytes.length);
            System.arraycopy(this.subtreeRootSig[i], 0, gmssSigNextPart, helpGmssSig.length + indexBytes.length, this.subtreeRootSig[i].length);
            System.arraycopy(authPathBytes, 0, gmssSigNextPart, helpGmssSig.length + indexBytes.length + this.subtreeRootSig[i].length, authPathBytes.length);
            --i;
        }
        byte[] gmssSig = new byte[gmssSigFirstPart.length + gmssSigNextPart.length];
        System.arraycopy(gmssSigFirstPart, 0, gmssSig, 0, gmssSigFirstPart.length);
        System.arraycopy(gmssSigNextPart, 0, gmssSig, gmssSigFirstPart.length, gmssSigNextPart.length);
        return gmssSig;
    }

    private void initVerify() {
        this.messDigestTrees.reset();
        GMSSPublicKeyParameters gmssPublicKey = (GMSSPublicKeyParameters)this.key;
        this.pubKeyBytes = gmssPublicKey.getPublicKey();
        this.gmssPS = gmssPublicKey.getParameters();
        this.numLayer = this.gmssPS.getNumOfLayers();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        boolean success = false;
        this.messDigestOTS.reset();
        byte[] help = message;
        int nextEntry = 0;
        int j = this.numLayer - 1;
        while (j >= 0) {
            WinternitzOTSVerify otsVerify = new WinternitzOTSVerify(this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[j]);
            int otsSigLength = otsVerify.getSignatureLength();
            message = help;
            int index = this.gmssUtil.bytesToIntLittleEndian(signature, nextEntry);
            byte[] otsSig = new byte[otsSigLength];
            System.arraycopy(signature, nextEntry += 4, otsSig, 0, otsSigLength);
            nextEntry += otsSigLength;
            byte[] otsPublicKey = otsVerify.Verify(message, otsSig);
            if (otsPublicKey == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] authPath = new byte[this.gmssPS.getHeightOfTrees()[j]][this.mdLength];
            int i = 0;
            while (i < authPath.length) {
                System.arraycopy(signature, nextEntry, authPath[i], 0, this.mdLength);
                nextEntry += this.mdLength;
                ++i;
            }
            help = new byte[this.mdLength];
            help = otsPublicKey;
            int count = 1 << authPath.length;
            count += index;
            int i2 = 0;
            while (i2 < authPath.length) {
                byte[] dest = new byte[this.mdLength << 1];
                if (count % 2 == 0) {
                    System.arraycopy(help, 0, dest, 0, this.mdLength);
                    System.arraycopy(authPath[i2], 0, dest, this.mdLength, this.mdLength);
                    count /= 2;
                } else {
                    System.arraycopy(authPath[i2], 0, dest, 0, this.mdLength);
                    System.arraycopy(help, 0, dest, this.mdLength, help.length);
                    count = (count - 1) / 2;
                }
                this.messDigestTrees.update(dest, 0, dest.length);
                help = new byte[this.messDigestTrees.getDigestSize()];
                this.messDigestTrees.doFinal(help, 0);
                ++i2;
            }
            --j;
        }
        if (Arrays.areEqual(this.pubKeyBytes, help)) {
            success = true;
        }
        return success;
    }
}

