/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LmsUtils;
import java.security.SecureRandom;

public class HSSKeyGenerationParameters
extends KeyGenerationParameters {
    private final LMSParameters[] lmsParameters;

    public HSSKeyGenerationParameters(LMSParameters[] lmsParameters, SecureRandom random) {
        super(random, LmsUtils.calculateStrength(lmsParameters[0]));
        if (lmsParameters.length == 0 || lmsParameters.length > 8) {
            throw new IllegalArgumentException("lmsParameters length should be between 1 and 8 inclusive");
        }
        this.lmsParameters = lmsParameters;
    }

    public int getDepth() {
        return this.lmsParameters.length;
    }

    public LMSParameters[] getLmsParameters() {
        return this.lmsParameters;
    }
}

