/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.MessageSigner;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSSignature;
import java.io.IOException;

public class HSSSigner
implements MessageSigner {
    private HSSPrivateKeyParameters privKey;
    private HSSPublicKeyParameters pubKey;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (HSSPrivateKeyParameters)param;
        } else {
            this.pubKey = (HSSPublicKeyParameters)param;
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        try {
            return HSS.generateSignature(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return HSS.verifySignature(this.pubKey, HSSSignature.getInstance(signature, this.pubKey.getL()), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

