/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.Composer;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMOtsPublicKey;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSContext;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSigParameters;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LMSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final LMSigParameters parameterSet;
    private final LMOtsParameters lmOtsType;
    private final byte[] I;
    private final byte[] T1;

    public LMSPublicKeyParameters(LMSigParameters parameterSet, LMOtsParameters lmOtsType, byte[] T1, byte[] I) {
        super(false);
        this.parameterSet = parameterSet;
        this.lmOtsType = lmOtsType;
        this.I = Arrays.clone(I);
        this.T1 = Arrays.clone(T1);
    }

    public static LMSPublicKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof LMSPublicKeyParameters) {
            return (LMSPublicKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int pubType = ((DataInputStream)src).readInt();
            LMSigParameters lmsParameter = LMSigParameters.getParametersForType(pubType);
            LMOtsParameters ostTypeCode = LMOtsParameters.getParametersForType(((DataInputStream)src).readInt());
            byte[] I = new byte[16];
            ((DataInputStream)src).readFully(I);
            byte[] T1 = new byte[lmsParameter.getM()];
            ((DataInputStream)src).readFully(T1);
            return new LMSPublicKeyParameters(lmsParameter, ostTypeCode, T1, I);
        }
        if (src instanceof byte[]) {
            InputStream in = null;
            try {
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMSPublicKeyParameters lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(in);
                return lMSPublicKeyParameters;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (src instanceof InputStream) {
            return LMSPublicKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.toByteArray();
    }

    public LMSigParameters getSigParameters() {
        return this.parameterSet;
    }

    public LMOtsParameters getOtsParameters() {
        return this.lmOtsType;
    }

    public LMSParameters getLMSParameters() {
        return new LMSParameters(this.getSigParameters(), this.getOtsParameters());
    }

    public byte[] getT1() {
        return Arrays.clone(this.T1);
    }

    boolean matchesT1(byte[] sig) {
        return Arrays.constantTimeAreEqual(this.T1, sig);
    }

    public byte[] getI() {
        return Arrays.clone(this.I);
    }

    byte[] refI() {
        return this.I;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMSPublicKeyParameters publicKey = (LMSPublicKeyParameters)o;
        if (!this.parameterSet.equals(publicKey.parameterSet)) {
            return false;
        }
        if (!this.lmOtsType.equals(publicKey.lmOtsType)) {
            return false;
        }
        if (!Arrays.areEqual(this.I, publicKey.I)) {
            return false;
        }
        return Arrays.areEqual(this.T1, publicKey.T1);
    }

    public int hashCode() {
        int result = this.parameterSet.hashCode();
        result = 31 * result + this.lmOtsType.hashCode();
        result = 31 * result + Arrays.hashCode(this.I);
        result = 31 * result + Arrays.hashCode(this.T1);
        return result;
    }

    byte[] toByteArray() {
        return Composer.compose().u32str(this.parameterSet.getType()).u32str(this.lmOtsType.getType()).bytes(this.I).bytes(this.T1).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] signature) {
        try {
            return this.generateOtsContext(LMSSignature.getInstance(signature));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot parse signature: " + e.getMessage());
        }
    }

    LMSContext generateOtsContext(LMSSignature S) {
        int ots_typecode = this.getOtsParameters().getType();
        if (S.getOtsSignature().getType().getType() != ots_typecode) {
            throw new IllegalArgumentException("ots type from lsm signature does not match ots signature type from embedded ots signature");
        }
        return new LMOtsPublicKey(LMOtsParameters.getParametersForType(ots_typecode), this.I, S.getQ(), null).createOtsContext(S);
    }

    @Override
    public boolean verify(LMSContext context) {
        return LMS.verifySignature(this, context);
    }
}

