/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.lms;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.MessageSigner;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMS;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSSignature;
import java.io.IOException;

public class LMSSigner
implements MessageSigner {
    private LMSPrivateKeyParameters privKey;
    private LMSPublicKeyParameters pubKey;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (LMSPrivateKeyParameters)param;
        } else {
            this.pubKey = (LMSPublicKeyParameters)param;
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        try {
            return LMS.generateSign(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return LMS.verifySignature(this.pubKey, LMSSignature.getInstance(signature), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

