/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTesla1p;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTesla3p;
import java.security.SecureRandom;

public final class QTESLAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int securityCategory;
    private SecureRandom secureRandom;

    @Override
    public void init(KeyGenerationParameters param) {
        QTESLAKeyGenerationParameters parameters = (QTESLAKeyGenerationParameters)param;
        this.secureRandom = parameters.getRandom();
        this.securityCategory = parameters.getSecurityCategory();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] privateKey = this.allocatePrivate(this.securityCategory);
        byte[] publicKey = this.allocatePublic(this.securityCategory);
        switch (this.securityCategory) {
            case 5: {
                QTesla1p.generateKeyPair(publicKey, privateKey, this.secureRandom);
                break;
            }
            case 6: {
                QTesla3p.generateKeyPair(publicKey, privateKey, this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.securityCategory);
            }
        }
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(this.securityCategory, publicKey), new QTESLAPrivateKeyParameters(this.securityCategory, privateKey));
    }

    private byte[] allocatePrivate(int securityCategory) {
        return new byte[QTESLASecurityCategory.getPrivateSize(securityCategory)];
    }

    private byte[] allocatePublic(int securityCategory) {
        return new byte[QTESLASecurityCategory.getPublicSize(securityCategory)];
    }
}

