/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.Tree;
import java.security.SecureRandom;

public class SPHINCS256KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private Digest treeDigest;

    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.treeDigest = ((SPHINCS256KeyGenerationParameters)param).getTreeDigest();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Tree.leafaddr a = new Tree.leafaddr();
        byte[] sk = new byte[1088];
        this.random.nextBytes(sk);
        byte[] pk = new byte[1056];
        System.arraycopy(sk, 32, pk, 0, 1024);
        a.level = 11;
        a.subtree = 0L;
        a.subleaf = 0L;
        HashFunctions hs = new HashFunctions(this.treeDigest);
        Tree.treehash(hs, pk, 1024, 5, sk, a, pk, 0);
        return new AsymmetricCipherKeyPair(new SPHINCSPublicKeyParameters(pk, this.treeDigest.getAlgorithmName()), new SPHINCSPrivateKeyParameters(sk, this.treeDigest.getAlgorithmName()));
    }
}

