/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.Seed;

class Wots {
    static final int WOTS_LOGW = 4;
    static final int WOTS_W = 16;
    static final int WOTS_L1 = 64;
    static final int WOTS_L = 67;
    static final int WOTS_LOG_L = 7;
    static final int WOTS_SIGBYTES = 2144;

    Wots() {
    }

    static void expand_seed(byte[] outseeds, int outOff, byte[] inseed, int inOff) {
        Wots.clear(outseeds, outOff, 2144);
        Seed.prg(outseeds, outOff, 2144L, inseed, inOff);
    }

    private static void clear(byte[] bytes, int offSet, int length) {
        int i = 0;
        while (i != length) {
            bytes[i + offSet] = 0;
            ++i;
        }
    }

    static void gen_chain(HashFunctions hs, byte[] out, int outOff, byte[] seed, int seedOff, byte[] masks, int masksOff, int chainlen) {
        int j = 0;
        while (j < 32) {
            out[j + outOff] = seed[j + seedOff];
            ++j;
        }
        int i = 0;
        while (i < chainlen && i < 16) {
            hs.hash_n_n_mask(out, outOff, out, outOff, masks, masksOff + i * 32);
            ++i;
        }
    }

    void wots_pkgen(HashFunctions hs, byte[] pk, int pkOff, byte[] sk, int skOff, byte[] masks, int masksOff) {
        Wots.expand_seed(pk, pkOff, sk, skOff);
        int i = 0;
        while (i < 67) {
            Wots.gen_chain(hs, pk, pkOff + i * 32, pk, pkOff + i * 32, masks, masksOff, 15);
            ++i;
        }
    }

    void wots_sign(HashFunctions hs, byte[] sig, int sigOff, byte[] msg, byte[] sk, byte[] masks) {
        int[] basew = new int[67];
        int c = 0;
        int i = 0;
        while (i < 64) {
            basew[i] = msg[i / 2] & 0xF;
            basew[i + 1] = (msg[i / 2] & 0xFF) >>> 4;
            c += 15 - basew[i];
            c += 15 - basew[i + 1];
            i += 2;
        }
        while (i < 67) {
            basew[i] = c & 0xF;
            c >>>= 4;
            ++i;
        }
        Wots.expand_seed(sig, sigOff, sk, 0);
        i = 0;
        while (i < 67) {
            Wots.gen_chain(hs, sig, sigOff + i * 32, sig, sigOff + i * 32, masks, 0, basew[i]);
            ++i;
        }
    }

    void wots_verify(HashFunctions hs, byte[] pk, byte[] sig, int sigOff, byte[] msg, byte[] masks) {
        int[] basew = new int[67];
        int c = 0;
        int i = 0;
        while (i < 64) {
            basew[i] = msg[i / 2] & 0xF;
            basew[i + 1] = (msg[i / 2] & 0xFF) >>> 4;
            c += 15 - basew[i];
            c += 15 - basew[i + 1];
            i += 2;
        }
        while (i < 67) {
            basew[i] = c & 0xF;
            c >>>= 4;
            ++i;
        }
        i = 0;
        while (i < 67) {
            Wots.gen_chain(hs, pk, i * 32, sig, sigOff + i * 32, masks, basew[i] * 32, 15 - basew[i]);
            ++i;
        }
    }
}

