/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsPeer;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.CertificateRequest;
import cn.win_trust_erpc.bouncycastle.tls.CertificateStatus;
import cn.win_trust_erpc.bouncycastle.tls.CertificateStatusRequest;
import cn.win_trust_erpc.bouncycastle.tls.MaxFragmentLength;
import cn.win_trust_erpc.bouncycastle.tls.NamedGroup;
import cn.win_trust_erpc.bouncycastle.tls.NewSessionTicket;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolName;
import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsDHUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsECCUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsExtensionsUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSKExternal;
import cn.win_trust_erpc.bouncycastle.tls.TlsPSKIdentityManager;
import cn.win_trust_erpc.bouncycastle.tls.TlsSRPLoginParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsServer;
import cn.win_trust_erpc.bouncycastle.tls.TlsServerContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsSession;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDHConfig;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsECConfig;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsServerContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected int[] offeredCipherSuites;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected boolean clientSentECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected Vector statusRequestV2;
    protected Vector trustedCAKeys;
    protected int selectedCipherSuite;
    protected Vector clientProtocolNames;
    protected ProtocolName selectedProtocolName;
    protected final Hashtable serverExtensions = new Hashtable();

    public AbstractTlsServer(TlsCrypto crypto) {
        super(crypto);
    }

    protected boolean allowCertificateStatus() {
        return true;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowMultiCertStatus() {
        return false;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected boolean allowTrustedCAIndication() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        return this.serverExtensions;
    }

    protected int getMaximumNegotiableCurveBits() {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int maxBits = 0;
        int i = 0;
        while (i < clientSupportedGroups.length) {
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(clientSupportedGroups[i]));
            ++i;
        }
        return maxBits;
    }

    protected int getMaximumNegotiableFiniteFieldBits() {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return NamedGroup.getMaximumFiniteFieldBits();
        }
        int maxBits = 0;
        int i = 0;
        while (i < clientSupportedGroups.length) {
            maxBits = Math.max(maxBits, NamedGroup.getFiniteFieldBits(clientSupportedGroups[i]));
            ++i;
        }
        return maxBits;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected boolean isSelectableCipherSuite(int cipherSuite, int availCurveBits, int availFiniteFieldBits, Vector sigAlgs) {
        return TlsUtils.isValidVersionForCipherSuite(cipherSuite, this.context.getServerVersion()) && availCurveBits >= TlsECCUtils.getMinimumCurveBits(cipherSuite) && availFiniteFieldBits >= TlsDHUtils.getMinimumFiniteFieldBits(cipherSuite) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(cipherSuite, sigAlgs);
    }

    protected boolean preferLocalCipherSuites() {
        return false;
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        this.selectedCipherSuite = cipherSuite;
        return true;
    }

    protected int selectDH(int minimumFiniteFieldBits) {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return this.selectDHDefault(minimumFiniteFieldBits);
        }
        int i = 0;
        while (i < clientSupportedGroups.length) {
            int namedGroup = clientSupportedGroups[i];
            if (NamedGroup.getFiniteFieldBits(namedGroup) >= minimumFiniteFieldBits) {
                return namedGroup;
            }
            ++i;
        }
        return -1;
    }

    protected int selectDHDefault(int minimumFiniteFieldBits) {
        return minimumFiniteFieldBits <= 2048 ? 256 : (minimumFiniteFieldBits <= 3072 ? 257 : (minimumFiniteFieldBits <= 4096 ? 258 : (minimumFiniteFieldBits <= 6144 ? 259 : (minimumFiniteFieldBits <= 8192 ? 260 : -1))));
    }

    protected int selectECDH(int minimumCurveBits) {
        int[] clientSupportedGroups = this.context.getSecurityParametersHandshake().getClientSupportedGroups();
        if (clientSupportedGroups == null) {
            return this.selectECDHDefault(minimumCurveBits);
        }
        int i = 0;
        while (i < clientSupportedGroups.length) {
            int namedGroup = clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(namedGroup) >= minimumCurveBits) {
                return namedGroup;
            }
            ++i;
        }
        return -1;
    }

    protected int selectECDHDefault(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : -1));
    }

    protected ProtocolName selectProtocolName() throws IOException {
        Vector serverProtocolNames = this.getProtocolNames();
        if (serverProtocolNames == null || serverProtocolNames.isEmpty()) {
            return null;
        }
        ProtocolName result = this.selectProtocolName(this.clientProtocolNames, serverProtocolNames);
        if (result == null) {
            throw new TlsFatalAlert(120);
        }
        return result;
    }

    protected ProtocolName selectProtocolName(Vector clientProtocolNames, Vector serverProtocolNames) {
        int i = 0;
        while (i < serverProtocolNames.size()) {
            ProtocolName serverProtocolName = (ProtocolName)serverProtocolNames.elementAt(i);
            if (clientProtocolNames.contains(serverProtocolName)) {
                return serverProtocolName;
            }
            ++i;
        }
        return null;
    }

    protected boolean shouldSelectProtocolNameEarly() {
        return true;
    }

    @Override
    public void init(TlsServerContext context) {
        this.context = context;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.offeredCipherSuites = null;
        this.clientExtensions = null;
        this.encryptThenMACOffered = false;
        this.maxFragmentLengthOffered = 0;
        this.truncatedHMacOffered = false;
        this.clientSentECPointFormats = false;
        this.certificateStatusRequest = null;
        this.selectedCipherSuite = -1;
        this.selectedProtocolName = null;
        this.serverExtensions.clear();
    }

    @Override
    public TlsSession getSessionToResume(byte[] sessionID) {
        return null;
    }

    @Override
    public byte[] getNewSessionID() {
        return null;
    }

    @Override
    public TlsPSKExternal getExternalPSK(Vector identities) {
        return null;
    }

    @Override
    public void notifySession(TlsSession session) {
    }

    @Override
    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
    }

    @Override
    public void notifyFallback(boolean isFallback) throws IOException {
        if (isFallback) {
            ProtocolVersion latestServerVersion;
            ProtocolVersion[] serverVersions = this.getProtocolVersions();
            ProtocolVersion clientVersion = this.context.getClientVersion();
            if (clientVersion.isTLS()) {
                latestServerVersion = ProtocolVersion.getLatestTLS(serverVersions);
            } else if (clientVersion.isDTLS()) {
                latestServerVersion = ProtocolVersion.getLatestDTLS(serverVersions);
            } else {
                throw new TlsFatalAlert(80);
            }
            if (latestServerVersion != null && latestServerVersion.isLaterVersionOf(clientVersion)) {
                throw new TlsFatalAlert(86);
            }
        }
    }

    @Override
    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (clientExtensions != null) {
            this.clientProtocolNames = TlsExtensionsUtils.getALPNExtensionClient(clientExtensions);
            if (this.shouldSelectProtocolNameEarly() && this.clientProtocolNames != null && !this.clientProtocolNames.isEmpty()) {
                this.selectedProtocolName = this.selectProtocolName();
            }
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(clientExtensions);
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.statusRequestV2 = TlsExtensionsUtils.getStatusRequestV2Extension(clientExtensions);
            this.trustedCAKeys = TlsExtensionsUtils.getTrustedCAKeysExtensionClient(clientExtensions);
            this.clientSentECPointFormats = TlsExtensionsUtils.getSupportedPointFormatsExtension(clientExtensions) != null;
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(clientExtensions);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion[] serverVersions = this.getProtocolVersions();
        ProtocolVersion[] clientVersions = this.context.getClientSupportedVersions();
        int i = 0;
        while (i < clientVersions.length) {
            ProtocolVersion clientVersion = clientVersions[i];
            if (ProtocolVersion.contains(serverVersions, clientVersion)) {
                return clientVersion;
            }
            ++i;
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int[] getSupportedGroups() throws IOException {
        return new int[]{29, 30, 23, 24, 256, 257, 258};
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsUtils.isTLSv13(negotiatedVersion)) {
            int commonCipherSuite13 = TlsUtils.getCommonCipherSuite13(negotiatedVersion, this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            if (commonCipherSuite13 >= 0 && this.selectCipherSuite(commonCipherSuite13)) {
                return commonCipherSuite13;
            }
        } else {
            Vector sigAlgs = TlsUtils.getUsableSignatureAlgorithms(securityParameters.getClientSigAlgs());
            int availCurveBits = this.getMaximumNegotiableCurveBits();
            int availFiniteFieldBits = this.getMaximumNegotiableFiniteFieldBits();
            int[] cipherSuites = TlsUtils.getCommonCipherSuites(this.offeredCipherSuites, this.getCipherSuites(), this.preferLocalCipherSuites());
            int i = 0;
            while (i < cipherSuites.length) {
                int cipherSuite = cipherSuites[i];
                if (this.isSelectableCipherSuite(cipherSuite, availCurveBits, availFiniteFieldBits, sigAlgs) && this.selectCipherSuite(cipherSuite)) {
                    return cipherSuite;
                }
                ++i;
            }
        }
        if (negotiatedVersion.equals(ProtocolVersion.SMv11)) {
            return 57363;
        }
        throw new TlsFatalAlert(40, "No selectable cipher suite");
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        boolean isTLSv13 = TlsUtils.isTLSv13(this.context);
        if (isTLSv13) {
            if (this.certificateStatusRequest != null) {
                this.allowCertificateStatus();
            }
        } else {
            if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addEncryptThenMACExtension(this.serverExtensions);
            }
            if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
                TlsExtensionsUtils.addTruncatedHMacExtension(this.serverExtensions);
            }
            if (this.clientSentECPointFormats && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                TlsExtensionsUtils.addSupportedPointFormatsExtension(this.serverExtensions, new short[1]);
            }
            if (this.statusRequestV2 != null && this.allowMultiCertStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request_v2);
            } else if (this.certificateStatusRequest != null && this.allowCertificateStatus()) {
                TlsExtensionsUtils.addEmptyExtensionData(this.serverExtensions, TlsExtensionsUtils.EXT_status_request);
            }
            if (this.trustedCAKeys != null && this.allowTrustedCAIndication()) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionServer(this.serverExtensions);
            }
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.serverExtensions, this.maxFragmentLengthOffered);
        }
        return this.serverExtensions;
    }

    @Override
    public void getServerExtensionsForConnection(Hashtable serverExtensions) throws IOException {
        if (!this.shouldSelectProtocolNameEarly() && this.clientProtocolNames != null && !this.clientProtocolNames.isEmpty()) {
            this.selectedProtocolName = this.selectProtocolName();
        }
        if (this.selectedProtocolName == null) {
            serverExtensions.remove(TlsExtensionsUtils.EXT_application_layer_protocol_negotiation);
        } else {
            TlsExtensionsUtils.addALPNExtensionServer(serverExtensions, this.selectedProtocolName);
        }
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public TlsPSKIdentityManager getPSKIdentityManager() throws IOException {
        return null;
    }

    @Override
    public TlsSRPLoginParameters getSRPLoginParameters() throws IOException {
        return null;
    }

    @Override
    public TlsDHConfig getDHConfig() throws IOException {
        int minimumFiniteFieldBits = TlsDHUtils.getMinimumFiniteFieldBits(this.selectedCipherSuite);
        int namedGroup = this.selectDH(minimumFiniteFieldBits);
        return TlsDHUtils.createNamedDHConfig(this.context, namedGroup);
    }

    @Override
    public TlsECConfig getECDHConfig() throws IOException {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int namedGroup = this.selectECDH(minimumCurveBits);
        return TlsECCUtils.createNamedECConfig(this.context, namedGroup);
    }

    @Override
    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

