/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

class Timeout {
    private long durationMillis;
    private long startMillis;

    Timeout(long durationMillis) {
        this(durationMillis, System.currentTimeMillis());
    }

    Timeout(long durationMillis, long currentTimeMillis) {
        this.durationMillis = Math.max(0L, durationMillis);
        this.startMillis = Math.max(0L, currentTimeMillis);
    }

    synchronized long remainingMillis(long currentTimeMillis) {
        if (this.startMillis > currentTimeMillis) {
            this.startMillis = currentTimeMillis;
            return this.durationMillis;
        }
        long elapsed = currentTimeMillis - this.startMillis;
        long remaining = this.durationMillis - elapsed;
        if (remaining <= 0L) {
            this.durationMillis = 0L;
            return 0L;
        }
        return remaining;
    }

    static int constrainWaitMillis(int waitMillis, Timeout timeout, long currentTimeMillis) {
        if (waitMillis < 0) {
            return -1;
        }
        int timeoutMillis = Timeout.getWaitMillis(timeout, currentTimeMillis);
        if (timeoutMillis < 0) {
            return -1;
        }
        if (waitMillis == 0) {
            return timeoutMillis;
        }
        if (timeoutMillis == 0) {
            return waitMillis;
        }
        return Math.min(waitMillis, timeoutMillis);
    }

    static Timeout forWaitMillis(int waitMillis) {
        return Timeout.forWaitMillis(waitMillis, System.currentTimeMillis());
    }

    static Timeout forWaitMillis(int waitMillis, long currentTimeMillis) {
        if (waitMillis < 0) {
            throw new IllegalArgumentException("'waitMillis' cannot be negative");
        }
        if (waitMillis > 0) {
            return new Timeout(waitMillis, currentTimeMillis);
        }
        return null;
    }

    static int getWaitMillis(Timeout timeout, long currentTimeMillis) {
        if (timeout == null) {
            return 0;
        }
        long remainingMillis = timeout.remainingMillis(currentTimeMillis);
        if (remainingMillis < 1L) {
            return -1;
        }
        if (remainingMillis > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remainingMillis;
    }

    static boolean hasExpired(Timeout timeout, long currentTimeMillis) {
        return timeout != null && timeout.remainingMillis(currentTimeMillis) < 1L;
    }
}

