/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsKeyExchange;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedAgreement;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentials;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsECDHKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedAgreement agreementCredentials;
    protected TlsCertificate ecdhPeerCertificate;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 16: 
            case 18: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHKeyExchange(int keyExchange) {
        super(TlsECDHKeyExchange.checkKeyExchange(keyExchange));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.ecdhPeerCertificate = serverCertificate.getCertificateAt(0).checkUsageInRole(2);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{66, 65};
    }

    @Override
    public void skipClientCredentials() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        this.agreementCredentials = TlsUtils.requireAgreementCredentials(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
    }

    @Override
    public void processClientCertificate(Certificate clientCertificate) throws IOException {
        this.ecdhPeerCertificate = clientCertificate.getCertificateAt(0).checkUsageInRole(2);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
    }

    @Override
    public boolean requiresCertificateVerify() {
        return false;
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        return this.agreementCredentials.generateAgreement(this.ecdhPeerCertificate);
    }
}

