/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.AbstractTlsKeyExchange;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentialedDecryptor;
import cn.win_trust_erpc.bouncycastle.tls.TlsCredentials;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncryptor;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSecret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TlsRSAKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsEncryptor serverEncryptor;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 1: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsRSAKeyExchange(int keyExchange) {
        super(TlsRSAKeyExchange.checkKeyExchange(keyExchange));
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        this.serverCredentials = TlsUtils.requireDecryptorCredentials(serverCredentials);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        this.serverEncryptor = serverCertificate.getCertificateAt(0).createEncryptor(3);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 2, 64};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        TlsUtils.requireSignerCredentials(clientCredentials);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsUtils.generateEncryptedPreMasterSecret(this.context, this.serverEncryptor, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readEncryptedPMS(this.context, input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }
}

