/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto;

import cn.win_trust_erpc.bouncycastle.tls.ProtocolVersion;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCipher;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsDecodeResult;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncodeResult;
import java.io.IOException;

public class TlsNullNullCipher
implements TlsCipher {
    public static final TlsNullNullCipher INSTANCE = new TlsNullNullCipher();

    @Override
    public int getCiphertextDecodeLimit(int plaintextLimit) {
        return plaintextLimit;
    }

    @Override
    public int getCiphertextEncodeLimit(int plaintextLength, int plaintextLimit) {
        return plaintextLength;
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit;
    }

    @Override
    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        byte[] result = new byte[headerAllocation + len];
        System.arraycopy(plaintext, offset, result, headerAllocation, len);
        return new TlsEncodeResult(result, 0, result.length, contentType);
    }

    @Override
    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        return new TlsDecodeResult(ciphertext, offset, len, recordType);
    }

    @Override
    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public boolean usesOpaqueRecordType() {
        return false;
    }
}

