/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.RSAKeyParameters;
import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.DefaultTlsCredentialedSigner;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoParameters;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsECDSA13Signer;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static BcTlsCertificate getEndEntity(BcTlsCrypto crypto, Certificate certificate) throws IOException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("No certificate");
        }
        return BcTlsCertificate.convert(crypto, certificate.getCertificateAt(0));
    }

    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            RSAKeyParameters pubKeyRSA;
            int signatureScheme;
            RSAKeyParameters privKeyRSA = (RSAKeyParameters)privateKey;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsRSAPSSSigner(crypto, privKeyRSA, signatureScheme);
            }
            try {
                pubKeyRSA = BcDefaultTlsCredentialedSigner.getEndEntity(crypto, certificate).getPubKeyRSA();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            signer = new BcTlsRSASigner(crypto, privKeyRSA, pubKeyRSA);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            signer = new BcTlsDSASigner(crypto, (DSAPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            int signatureScheme;
            ECPrivateKeyParameters privKeyEC = (ECPrivateKeyParameters)privateKey;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsECDSA13Signer(crypto, privKeyEC, signatureScheme);
            }
            signer = new BcTlsECDSASigner(crypto, privKeyEC);
        } else if (privateKey instanceof Ed25519PrivateKeyParameters) {
            signer = new BcTlsEd25519Signer(crypto, (Ed25519PrivateKeyParameters)privateKey);
        } else if (privateKey instanceof Ed448PrivateKeyParameters) {
            signer = new BcTlsEd448Signer(crypto, (Ed448PrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

