/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.CryptoException;
import cn.win_trust_erpc.bouncycastle.crypto.digests.NullDigest;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.crypto.signers.DSADigestSigner;
import cn.win_trust_erpc.bouncycastle.crypto.signers.ECDSASigner;
import cn.win_trust_erpc.bouncycastle.crypto.signers.HMacDSAKCalculator;
import cn.win_trust_erpc.bouncycastle.tls.SignatureAndHashAlgorithm;
import cn.win_trust_erpc.bouncycastle.tls.SignatureScheme;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcTlsECDSA13Signer
extends BcTlsSigner {
    private final int signatureScheme;

    public BcTlsECDSA13Signer(BcTlsCrypto crypto, ECPrivateKeyParameters privateKey, int signatureScheme) {
        super(crypto, privateKey);
        if (!SignatureScheme.isECDSA(signatureScheme)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = signatureScheme;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm == null || SignatureScheme.from(algorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        int cryptoHashAlgorithm = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        ECDSASigner dsa = new ECDSASigner(new HMacDSAKCalculator(this.crypto.createDigest(cryptoHashAlgorithm)));
        DSADigestSigner signer = new DSADigestSigner(dsa, new NullDigest());
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

