/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls.crypto.impl.bc;

import cn.win_trust_erpc.bouncycastle.crypto.InvalidCipherTextException;
import cn.win_trust_erpc.bouncycastle.crypto.encodings.PKCS1Encoding;
import cn.win_trust_erpc.bouncycastle.crypto.engines.RSABlindedEngine;
import cn.win_trust_erpc.bouncycastle.crypto.params.ParametersWithRandom;
import cn.win_trust_erpc.bouncycastle.crypto.params.RSAKeyParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCrypto;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsEncryptor;
import java.io.IOException;

final class BcTlsRSAEncryptor
implements TlsEncryptor {
    private final TlsCrypto crypto;
    private final RSAKeyParameters pubKeyRSA;

    private static RSAKeyParameters checkPublicKey(RSAKeyParameters pubKeyRSA) {
        if (pubKeyRSA == null || pubKeyRSA.isPrivate()) {
            throw new IllegalArgumentException("No public RSA key provided");
        }
        return pubKeyRSA;
    }

    BcTlsRSAEncryptor(TlsCrypto crypto, RSAKeyParameters pubKeyRSA) {
        this.crypto = crypto;
        this.pubKeyRSA = BcTlsRSAEncryptor.checkPublicKey(pubKeyRSA);
    }

    @Override
    public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
        try {
            PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
            encoding.init(true, new ParametersWithRandom(this.pubKeyRSA, this.crypto.getSecureRandom()));
            return encoding.processBlock(input, inOff, length);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

