/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api;

import com.bocom.api.BocomEncryptRequest;
import com.bocom.api.BocomResponse;
import com.bocom.api.security.keygen.AESKeyGen;
import com.bocom.api.security.keygen.SM4KeyGen;
import com.bocom.api.utils.BocomEncrypt;
import com.bocom.api.utils.enums.EncryptPolicy;
import com.bocom.api.utils.enums.EncryptType;

public abstract class BocomDownloadEncryptRequest<T extends BocomResponse>
extends BocomEncryptRequest<T> {
    private String downloadPath;
    private EncryptType encryptType = EncryptType.RSA_AND_AES;
    private String hashCode;
    private String encryptKey = AESKeyGen.getKey(256);

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    @Override
    public EncryptType getEncryptType() {
        return this.encryptType;
    }

    @Override
    public void setEncryptType(EncryptType encryptType) {
        if (encryptType == EncryptType.SM2_AND_SM4) {
            this.encryptType = encryptType;
            this.encryptKey = SM4KeyGen.getKey();
        }
    }

    public String getHashCode() {
        return this.hashCode;
    }

    public void setHashCode(String hashCode) {
        this.hashCode = hashCode;
    }

    @Override
    public String getEncryptKey() {
        return this.encryptKey;
    }

    @Override
    public EncryptPolicy getEncryptPolicy() {
        return EncryptPolicy.FILE;
    }

    public void decryptFile(String fileName) throws Exception {
        BocomEncrypt.decryptFile(this.encryptKey, this.encryptType, this.downloadPath, fileName);
    }
}

