/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api;

import com.bocom.api.AbstractBocomRequest;
import com.bocom.api.BocomApiException;
import com.bocom.api.BocomResponse;
import com.bocom.api.security.keygen.AESKeyGen;
import com.bocom.api.security.keygen.SM4KeyGen;
import com.bocom.api.utils.BocomEncrypt;
import com.bocom.api.utils.enums.EncryptPolicy;
import com.bocom.api.utils.enums.EncryptType;

public abstract class BocomEncryptRequest<T extends BocomResponse>
extends AbstractBocomRequest<T> {
    private EncryptType encryptType = EncryptType.RSA_AND_AES;
    private String encrypytKey = AESKeyGen.getKey(256);

    public abstract EncryptPolicy getEncryptPolicy();

    public void setEncryptType(EncryptType encryptType) {
        if (encryptType == EncryptType.SM2_AND_SM4) {
            this.encryptType = encryptType;
            this.encrypytKey = SM4KeyGen.getKey();
        }
    }

    public EncryptType getEncryptType() {
        return this.encryptType;
    }

    public String getEncryptKey() {
        return this.encrypytKey;
    }

    public String encrypt(String data) {
        String cipher = null;
        try {
            cipher = BocomEncrypt.symEncryptContent(data, this.encryptType, this.encrypytKey, "UTF-8");
        }
        catch (BocomApiException e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
        return cipher;
    }

    public String decrypt(String data) {
        String cipher = null;
        try {
            cipher = BocomEncrypt.symDecryptContent(data, this.encryptType, this.encrypytKey, "UTF-8");
        }
        catch (BocomApiException e) {
            throw new RuntimeException("\u52a0\u5bc6\u5b57\u7b26\u4e32[" + data + "]\u65f6\u9047\u5230\u5f02\u5e38", e);
        }
        return cipher;
    }
}

