/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.crypt.impl;

import com.bocom.api.security.crypt.ApiCryptor;
import com.bocom.api.security.keygen.SM4KeyGen;
import com.bocom.api.utils.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM4Engine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Cryptor
implements ApiCryptor {
    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    @Override
    public String encrypt(String data, String key, String charset) {
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(key));
            byte[] dataBytes = data.getBytes(charset);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new SM4Engine()), (BlockCipherPadding)new PKCS7Padding());
            cipher.init(true, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(dataBytes.length)];
            int len = cipher.processBytes(dataBytes, 0, dataBytes.length, output, 0);
            cipher.doFinal(output, len);
            return Base64.encode(output);
        }
        catch (Exception e) {
            throw new RuntimeException("\u62a5\u6587\u4f53\u52a0\u5bc6\u5931\u8d25,\u660e\u6587:" + data + "\u5bc6\u94a5:" + key, e);
        }
    }

    @Override
    public String decrypt(String encrypted, String key, String charset) {
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(key));
            byte[] encryptBytes = Base64.decode(encrypted);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new SM4Engine()), (BlockCipherPadding)new PKCS7Padding());
            cipher.init(false, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(encryptBytes.length)];
            int len = cipher.processBytes(encryptBytes, 0, encryptBytes.length, output, 0);
            int len2 = cipher.doFinal(output, len);
            byte[] rawData = new byte[len + len2];
            System.arraycopy(output, 0, rawData, 0, rawData.length);
            return new String(rawData, Charset.forName(charset));
        }
        catch (Exception e) {
            throw new RuntimeException("\u62a5\u6587\u4f53\u52a0\u89e3\u5bc6\u5931\u8d25,\u5bc6\u6587:" + encrypted + "\u5bc6\u94a5:" + key, e);
        }
    }

    public ByteArrayOutputStream encryptFile(InputStream in, String key) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(key));
            byte[] bytes = SM4Cryptor.toByteArray(in);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new SM4Engine()), (BlockCipherPadding)new PKCS7Padding());
            cipher.init(true, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, output, 0);
            cipher.doFinal(output, len);
            baos.write(output);
            baos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u52a0\u5bc6\u5931\u8d25", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e1) {
                throw new RuntimeException("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25", e1);
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("\u5b57\u8282\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25", e);
            }
        }
        return baos;
    }

    public ByteArrayOutputStream decryptFile(InputStream in, String key) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            KeyParameter kp = new KeyParameter(Base64.decode(key));
            byte[] bytes = SM4Cryptor.toByteArray(in);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new SM4Engine()), (BlockCipherPadding)new PKCS7Padding());
            cipher.init(false, (CipherParameters)kp);
            byte[] output = new byte[cipher.getOutputSize(bytes.length)];
            int len = cipher.processBytes(bytes, 0, bytes.length, output, 0);
            int len2 = cipher.doFinal(output, len);
            byte[] rawData = new byte[len + len2];
            System.arraycopy(output, 0, rawData, 0, rawData.length);
            baos.write(rawData);
            baos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u89e3\u5bc6\u5931\u8d25", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e1) {
                throw new RuntimeException("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25", e1);
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("\u5b57\u8282\u8f93\u51fa\u6d41\u5173\u95ed\u5931\u8d25", e);
            }
        }
        return baos;
    }

    public static void main(String[] args) throws Exception {
        String sm4Key = SM4KeyGen.getKey();
        try {
            FileInputStream inputStream = new FileInputStream(new File("C:\\Users\\Administrator\\Desktop\\123.txt"));
            SM4Cryptor sm4Cryptor = new SM4Cryptor();
            ByteArrayOutputStream byteArrayOutputStream1 = sm4Cryptor.encryptFile(inputStream, sm4Key);
            FileOutputStream fileOutputStream1 = new FileOutputStream(new File("C:\\Users\\Administrator\\Desktop\\cipher.txt"));
            fileOutputStream1.write(byteArrayOutputStream1.toByteArray());
            ByteArrayOutputStream byteArrayOutputStream2 = sm4Cryptor.decryptFile(new FileInputStream(new File("C:\\Users\\Administrator\\Desktop\\cipher.txt")), sm4Key);
            FileOutputStream fileOutputStream2 = new FileOutputStream(new File("C:\\Users\\Administrator\\Desktop\\plain.txt"));
            fileOutputStream2.write(byteArrayOutputStream2.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

