/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.digest.impl;

import com.bocom.api.security.digest.ApiDigest;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class DefaultDigest
implements ApiDigest {
    public static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public String digest(byte[] message, String algorithm) throws Exception {
        MessageDigest messagedigest = MessageDigest.getInstance(algorithm);
        return DefaultDigest.toHexString(messagedigest.digest(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String digest(InputStream in, String algorithm) throws Exception {
        MessageDigest messagedigest = null;
        BufferedInputStream inTmp = null;
        try {
            int len;
            messagedigest = MessageDigest.getInstance(algorithm);
            inTmp = new BufferedInputStream(in);
            int bufSize = 1024;
            byte[] buffer = new byte[bufSize];
            while (-1 != (len = inTmp.read(buffer, 0, bufSize))) {
                messagedigest.update(buffer, 0, len);
            }
        }
        finally {
            try {
                if (inTmp != null) {
                    inTmp.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("inputStream close error", e);
            }
        }
        return DefaultDigest.toHexString(messagedigest.digest());
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_CHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_CHAR[b[i] & 0xF]);
        }
        return sb.toString();
    }
}

