/*
 * Decompiled with CFR 0.152.
 */
package com.bocom.api.security.sign.impl;

import com.bocom.api.security.sign.ApiSignature;
import com.bocom.api.utils.Base64;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSASignature
implements ApiSignature {
    private static final String RSA_ALG = "RSA";

    @Override
    public String sign(byte[] data, byte[] privateKey, String algorithm) throws Exception {
        PKCS8EncodedKeySpec pksc = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyfactory = KeyFactory.getInstance(RSA_ALG);
        PrivateKey pk = keyfactory.generatePrivate(pksc);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(pk);
        signature.update(data);
        return Base64.encode(signature.sign());
    }

    @Override
    public boolean verify(byte[] data, byte[] publicKey, String sign, String algorithm) throws Exception {
        X509EncodedKeySpec xksc = new X509EncodedKeySpec(publicKey);
        KeyFactory keyfactory = KeyFactory.getInstance(RSA_ALG);
        PublicKey pk = keyfactory.generatePublic(xksc);
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(pk);
        signature.update(data);
        return signature.verify(Base64.decode(sign));
    }
}

