/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.activemq.impl;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import netbank.firm.activemq.ProducerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class SimpleProducerServiceImpl
implements ProducerService {
    private static final Log LOG = LogFactory.getLog(SimpleProducerServiceImpl.class);
    private JmsTemplate jmsTemplate;

    @Override
    public void sendMessage(Destination destination, final String msg) {
        LOG.debug((Object)("\u5411\u961f\u5217" + destination.toString() + "\u53d1\u9001\u4e86\u6d88\u606f\uff1a" + msg));
        this.jmsTemplate.send(destination, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(msg);
            }
        });
    }

    @Override
    public void sendMessage(final String msg) {
        LOG.debug((Object)("\u5411\u961f\u5217" + this.jmsTemplate.getDefaultDestination().toString() + "\u53d1\u9001\u4e86\u6d88\u606f\uff1a" + msg + ",DeliveryMode:" + this.jmsTemplate.getDeliveryMode()));
        this.jmsTemplate.setDeliveryMode(2);
        this.jmsTemplate.send(new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(msg);
            }
        });
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }
}

