/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.decoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.decoder.DcfirmMessageToMessageDecoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageType;
import netbank.firm.model.SysExpMessage;
import netbank.firm.serial.tool.MessageWrapper;

public class MessageDecoder
extends DcfirmMessageToMessageDecoder<Message> {
    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            Object obj = MessageWrapper.unwrap(msg);
            out.add(obj);
            if (msg.getMessageType() == MessageType.SYSERR) {
                SysExpMessage sem = (SysExpMessage)obj;
                DcfirmException sysExp = new DcfirmException(ExceptionCode.S004.getCode(), sem.getErrMsg());
                ctx.fireExceptionCaught((Throwable)sysExp);
            }
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U111, (Throwable)e);
        }
    }
}

